/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MockLogService
implements LogService {
    private final Logger log;

    public MockLogService(Class<?> loggerContext) {
        this.log = LoggerFactory.getLogger(loggerContext);
    }

    public void log(int level, String message) {
        switch (level) {
            case 1: {
                this.log.error(message);
                break;
            }
            case 2: {
                this.log.warn(message);
                break;
            }
            case 3: {
                this.log.info(message);
                break;
            }
            case 4: {
                this.log.debug(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log level: " + level);
            }
        }
    }

    public void log(int level, String message, Throwable exception) {
        switch (level) {
            case 1: {
                this.log.error(message, exception);
                break;
            }
            case 2: {
                this.log.warn(message, exception);
                break;
            }
            case 3: {
                this.log.info(message, exception);
                break;
            }
            case 4: {
                this.log.debug(message, exception);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log level: " + level);
            }
        }
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(level, message);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(level, message, exception);
    }
}

