/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.groups.Default;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.core.filter.impl.JacksonPropertyNodeNameProvider;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.AbstractMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;

public class ParameterValidatorFilter
extends AbstractFilter
implements ProviderFilter,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterValidatorFilter.class);
    public static final String NAME = "validator";
    public static final String HIBERNATE_VALIDATE_PREFIX = "hibernate.validator";
    public static final String ENABLE_EL = "servicecomb.filters.validation.useResourceBundleMessageInterpolator";
    protected ExecutableValidator validator;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getOrder() {
        return 1000;
    }

    public void afterPropertiesSet() {
        this.validator = this.createValidatorFactory().getValidator().forExecutables();
        this.initValidate();
    }

    private void initValidate() {
        try {
            Model model = new Model("foo", 23);
            Service instance = new Service();
            Method method = Service.class.getMethod("service", Model.class);
            Object[] args = new Object[]{model};
            this.validator.validateParameters((Object)instance, method, args, new Class[]{Default.class});
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    protected ValidatorFactory createValidatorFactory() {
        Configuration validatorConfiguration = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).propertyNodeNameProvider((PropertyNodeNameProvider)new JacksonPropertyNodeNameProvider())).messageInterpolator((MessageInterpolator)this.messageInterpolator());
        Map properties = ConfigUtil.stringPropertiesWithPrefix((Environment)this.environment, (String)HIBERNATE_VALIDATE_PREFIX);
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                validatorConfiguration.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return validatorConfiguration.buildValidatorFactory();
    }

    protected AbstractMessageInterpolator messageInterpolator() {
        if (this.useResourceBundleMessageInterpolator()) {
            return new ResourceBundleMessageInterpolator();
        }
        return new ParameterMessageInterpolator();
    }

    private boolean useResourceBundleMessageInterpolator() {
        return (Boolean)this.environment.getProperty(ENABLE_EL, Boolean.TYPE, (Object)false);
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        Set<ConstraintViolation<Object>> violations = this.doValidate(invocation);
        if (violations.size() > 0) {
            LOGGER.error("Parameter validation failed : " + violations);
            return AsyncUtils.completeExceptionally((Throwable)new ConstraintViolationException(violations));
        }
        return nextNode.onFilter(invocation);
    }

    protected Set<ConstraintViolation<Object>> doValidate(Invocation invocation) {
        SwaggerProducerOperation producerOperation = invocation.getOperationMeta().getSwaggerProducerOperation();
        return this.validator.validateParameters(producerOperation.getProducerInstance(), producerOperation.getProducerMethod(), invocation.toProducerArguments(), new Class[]{Default.class});
    }

    private static class Model {
        @NotNull
        String name;
        @Min(value=10L)
        @Min(value=10L) int age;

        Model(String name, int age) {
            this.name = name;
            this.age = age;
        }
    }

    private static class Service {
        private Service() {
        }

        public void service(@Valid Model model) {
        }
    }
}

