/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.client.naming.NacosNamingService;
import java.util.Objects;
import java.util.Properties;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.registry.nacos.NacosDiscoveryProperties;
import org.springframework.core.env.Environment;

public class NamingServiceManager {
    private static volatile NamingService namingService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingService buildNamingService(Environment environment, NacosDiscoveryProperties properties) {
        if (!Objects.isNull(namingService)) return namingService;
        Class<NamingServiceManager> clazz = NamingServiceManager.class;
        synchronized (NamingServiceManager.class) {
            if (!Objects.isNull(namingService)) return namingService;
            try {
                namingService = new NacosNamingService(NamingServiceManager.getProperties(environment, properties));
            }
            catch (NacosException e) {
                throw new IllegalStateException("build namingService failed.");
            }
            return namingService;
        }
    }

    private static Properties getProperties(Environment environment, NacosDiscoveryProperties nacosDiscoveryProperties) {
        Properties properties = new Properties();
        properties.put("namespace", BootStrapProperties.readServiceEnvironment((Environment)environment));
        properties.put("serverAddr", nacosDiscoveryProperties.getServerAddr());
        if (nacosDiscoveryProperties.getUsername() != null) {
            properties.put("username", nacosDiscoveryProperties.getUsername());
        }
        if (nacosDiscoveryProperties.getPassword() != null) {
            properties.put("password", nacosDiscoveryProperties.getPassword());
        }
        if (nacosDiscoveryProperties.getAccessKey() != null) {
            properties.put("accessKey", nacosDiscoveryProperties.getAccessKey());
        }
        if (nacosDiscoveryProperties.getSecretKey() != null) {
            properties.put("secretKey", nacosDiscoveryProperties.getSecretKey());
        }
        if (nacosDiscoveryProperties.getLogName() != null) {
            properties.put("com.alibaba.nacos.naming.log.filename", nacosDiscoveryProperties.getLogName());
        }
        properties.put("clusterName", nacosDiscoveryProperties.getClusterName());
        properties.put("namingLoadCacheAtStart", nacosDiscoveryProperties.getNamingLoadCacheAtStart());
        return properties;
    }
}

