/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.DynamicPropertyUpdater;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicWatchedConfigurationExt
extends ConcurrentMapConfiguration
implements WatchedUpdateListener {
    private final boolean ignoreDeletesFromSource;
    private final DynamicPropertyUpdater updater;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicWatchedConfigurationExt.class);

    private DynamicWatchedConfigurationExt(WatchedConfigurationSource source, boolean ignoreDeletesFromSource, DynamicPropertyUpdater updater) {
        this.ignoreDeletesFromSource = ignoreDeletesFromSource;
        this.updater = updater;
        this.setDelimiterParsingDisabled(true);
        try {
            Map currentData = source.getCurrentData();
            WatchedUpdateResult result = WatchedUpdateResult.createFull((Map)currentData);
            this.updateConfiguration(result);
        }
        catch (Exception exc) {
            LOGGER.error("could not getCurrentData() from the WatchedConfigurationSource", (Throwable)exc);
        }
        source.addUpdateListener((WatchedUpdateListener)this);
    }

    public DynamicWatchedConfigurationExt(WatchedConfigurationSource source) {
        this(source, false, new DynamicPropertyUpdater());
    }

    public void updateConfiguration(WatchedUpdateResult result) {
        this.updater.updateProperties(result, (Configuration)this, this.ignoreDeletesFromSource);
    }
}

