/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.table.CassandraMaxQuota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.Limits;
import org.apache.james.mailbox.quota.QuotaCodec;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

@Deprecated
public class CassandraPerUserMaxQuotaDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement setMaxStorageStatement;
    private final PreparedStatement setMaxMessageStatement;
    private final PreparedStatement getMaxStatement;
    private final PreparedStatement removeMaxStorageStatement;
    private final PreparedStatement removeMaxMessageStatement;

    @Inject
    public CassandraPerUserMaxQuotaDao(CqlSession session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.setMaxStorageStatement = session.prepare(this.setMaxStorageStatement().build());
        this.setMaxMessageStatement = session.prepare(this.setMaxMessageStatement().build());
        this.getMaxStatement = session.prepare(this.getMaxStatement().build());
        this.removeMaxStorageStatement = session.prepare(this.removeMaxStorageStatement().build());
        this.removeMaxMessageStatement = session.prepare(this.removeMaxMessageStatement().build());
    }

    private Delete removeMaxMessageStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"maxQuota").column(CassandraMaxQuota.MESSAGE_COUNT).where((Relation)Relation.column((CqlIdentifier)CassandraMaxQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()));
    }

    private Delete removeMaxStorageStatement() {
        return (Delete)QueryBuilder.deleteFrom((String)"maxQuota").column(CassandraMaxQuota.STORAGE).where((Relation)Relation.column((CqlIdentifier)CassandraMaxQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()));
    }

    private Select getMaxStatement() {
        return (Select)QueryBuilder.selectFrom((String)"maxQuota").all().where((Relation)Relation.column((CqlIdentifier)CassandraMaxQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()));
    }

    private Insert setMaxMessageStatement() {
        return QueryBuilder.insertInto((String)"maxQuota").value(CassandraMaxQuota.QUOTA_ROOT, (Term)QueryBuilder.bindMarker()).value(CassandraMaxQuota.MESSAGE_COUNT, (Term)QueryBuilder.bindMarker());
    }

    private Insert setMaxStorageStatement() {
        return QueryBuilder.insertInto((String)"maxQuota").value(CassandraMaxQuota.QUOTA_ROOT, (Term)QueryBuilder.bindMarker()).value(CassandraMaxQuota.STORAGE, (Term)QueryBuilder.bindMarker());
    }

    Mono<Void> setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        return this.queryExecutor.executeVoid((Statement)this.setMaxStorageStatement.bind(new Object[]{quotaRoot.getValue(), QuotaCodec.quotaValueToLong((QuotaLimitValue)maxStorageQuota)}));
    }

    Mono<Void> setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        return this.queryExecutor.executeVoid((Statement)this.setMaxMessageStatement.bind(new Object[]{quotaRoot.getValue(), QuotaCodec.quotaValueToLong((QuotaLimitValue)maxMessageCount)}));
    }

    Mono<QuotaSizeLimit> getMaxStorage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> Optional.ofNullable((Long)row.get(CassandraMaxQuota.STORAGE, Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    Mono<QuotaCountLimit> getMaxMessage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> Optional.ofNullable((Long)row.get(CassandraMaxQuota.MESSAGE_COUNT, Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    Mono<Limits> getLimits(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> {
            Optional<Long> sizeLimit = Optional.ofNullable((Long)row.get(CassandraMaxQuota.STORAGE, Long.class));
            Optional<Long> countLimit = Optional.ofNullable((Long)row.get(CassandraMaxQuota.MESSAGE_COUNT, Long.class));
            return new Limits(sizeLimit.flatMap(QuotaCodec::longToQuotaSize), countLimit.flatMap(QuotaCodec::longToQuotaCount));
        }).switchIfEmpty(Mono.just((Object)Limits.empty()));
    }

    Mono<Void> removeMaxMessage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeVoid((Statement)this.removeMaxMessageStatement.bind(new Object[]{quotaRoot.getValue()}));
    }

    Mono<Void> removeMaxStorage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeVoid((Statement)this.removeMaxStorageStatement.bind(new Object[]{quotaRoot.getValue()}));
    }
}

