/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class MessageInconsistenciesEntry {
    private final String mailboxId;
    private final String messageId;
    private final Long messageUid;

    public static Builder.RequireMailboxId builder() {
        return mailboxId -> messageId -> messageUid -> new MessageInconsistenciesEntry(mailboxId, messageId, messageUid);
    }

    private MessageInconsistenciesEntry(@JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="messageId") String messageId, @JsonProperty(value="uid") Long messageUid) {
        this.mailboxId = mailboxId;
        this.messageId = messageId;
        this.messageUid = messageUid;
    }

    @JsonProperty(value="mailboxId")
    public String getMailboxId() {
        return this.mailboxId;
    }

    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="uid")
    public Long getMessageUid() {
        return this.messageUid;
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageInconsistenciesEntry) {
            MessageInconsistenciesEntry that = (MessageInconsistenciesEntry)o;
            return Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.messageUid, that.messageUid);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxId, this.messageId, this.messageUid);
    }

    public static interface Builder {

        @FunctionalInterface
        public static interface RequireMessageUid {
            public MessageInconsistenciesEntry messageUid(Long var1);
        }

        @FunctionalInterface
        public static interface RequireMessageId {
            public RequireMessageUid messageId(String var1);
        }

        @FunctionalInterface
        public static interface RequireMailboxId {
            public RequireMessageId mailboxId(String var1);
        }
    }
}

