/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import jakarta.inject.Inject;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.james.core.Username;

public interface Disconnector {
    public static final Disconnector NOOP = user -> {};

    public void disconnect(Predicate<Username> var1);

    public static class CompositeDisconnector
    implements Disconnector {
        private final Set<Disconnector> disconnectorSet;

        @Inject
        public CompositeDisconnector(Set<Disconnector> disconnectorSet) {
            this.disconnectorSet = disconnectorSet;
        }

        @Override
        public void disconnect(Predicate<Username> username) {
            this.disconnectorSet.forEach(disconnector -> disconnector.disconnect(username));
        }
    }
}

