/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFEntry;
import com.unboundid.ldap.sdk.unboundidds.tools.SplitLDIFTranslator;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class SplitLDIFFewestEntriesTranslator
extends SplitLDIFTranslator {
    @Nullable
    private final ConcurrentHashMap<String, Set<String>> rdnCache;
    @NotNull
    private final Map<Set<String>, AtomicLong> setCounts;
    @NotNull
    private final Set<String> outsideSplitBaseSetNames;
    @NotNull
    private final Set<String> splitBaseEntrySetNames;

    SplitLDIFFewestEntriesTranslator(@NotNull DN splitBaseDN, int numSets, boolean assumeFlatDIT, boolean addEntriesOutsideSplitToAllSets, boolean addEntriesOutsideSplitToDedicatedSet) {
        super(splitBaseDN);
        this.rdnCache = assumeFlatDIT ? null : new ConcurrentHashMap(StaticUtils.computeMapCapacity(100));
        this.outsideSplitBaseSetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets + 1));
        this.splitBaseEntrySetNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(numSets));
        if (addEntriesOutsideSplitToDedicatedSet) {
            this.outsideSplitBaseSetNames.add(".outside-split");
        }
        this.setCounts = new LinkedHashMap<Set<String>, AtomicLong>(StaticUtils.computeMapCapacity(numSets));
        for (int i = 0; i < numSets; ++i) {
            String setName = ".set" + (i + 1);
            Set<String> setSet = Collections.singleton(setName);
            this.setCounts.put(setSet, new AtomicLong(0L));
            this.splitBaseEntrySetNames.add(setName);
            if (!addEntriesOutsideSplitToAllSets) continue;
            this.outsideSplitBaseSetNames.add(setName);
        }
    }

    @Override
    @NotNull
    public SplitLDIFEntry translate(@NotNull Entry original, long firstLineNumber) throws LDIFException {
        DN dn;
        try {
            dn = original.getParsedDN();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_FEWEST_ENTRIES_TRANSLATOR_CANNOT_PARSE_DN.get(le.getMessage()), this.getErrorSetNames());
        }
        if (!dn.isDescendantOf(this.getSplitBaseDN(), true)) {
            return this.createEntry(original, this.outsideSplitBaseSetNames);
        }
        if (dn.equals(this.getSplitBaseDN())) {
            return this.createEntry(original, this.splitBaseEntrySetNames);
        }
        RDN[] rdns = dn.getRDNs();
        int targetRDNIndex = rdns.length - this.getSplitBaseRDNs().length - 1;
        String normalizedRDNString = rdns[targetRDNIndex].toNormalizedString();
        if (targetRDNIndex > 0) {
            if (this.rdnCache == null) {
                return this.createEntry(original, ToolMessages.ERR_SPLIT_LDIF_FEWEST_ENTRIES_TRANSLATOR_NON_FLAT_DIT.get(this.getSplitBaseDN().toString()), this.getErrorSetNames());
            }
            Set<String> sets = this.rdnCache.get(normalizedRDNString);
            if (sets != null) {
                this.setCounts.get(sets).incrementAndGet();
            }
            return this.createEntry(original, sets);
        }
        long lowestCount = Long.MAX_VALUE;
        Set<String> lowestCountSetNames = null;
        for (Map.Entry<Set<String>, AtomicLong> e : this.setCounts.entrySet()) {
            long count = e.getValue().get();
            if (count >= lowestCount) continue;
            lowestCount = count;
            lowestCountSetNames = e.getKey();
        }
        this.setCounts.get(lowestCountSetNames).incrementAndGet();
        if (this.rdnCache != null) {
            this.rdnCache.put(normalizedRDNString, lowestCountSetNames);
        }
        return this.createEntry(original, lowestCountSetNames);
    }
}

