/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateTrustBehavior;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public final class TrustManagerProviderReplaceCertificateTrustBehavior
extends ReplaceCertificateTrustBehavior {
    static final byte TYPE_TRUST_BEHAVIOR = -124;
    private static final long serialVersionUID = 6812233987373145427L;
    @NotNull
    private final String providerName;

    public TrustManagerProviderReplaceCertificateTrustBehavior(@NotNull String providerName) {
        Validator.ensureNotNullOrEmpty(providerName, "TrustManagerProviderReplaceCertificateTrustBehavior.providerName must mot be null or empty.");
        this.providerName = providerName;
    }

    @NotNull
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    @NotNull
    public ASN1Element encode() {
        return new ASN1OctetString(-124, this.providerName);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TrustManagerProviderReplaceCertificateTrustBehavior(providerName='");
        buffer.append(this.providerName);
        buffer.append("')");
    }
}

