/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeListener;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class MoveSubtreeProperties {
    private boolean suppressReferentialIntegrityUpdates;
    private boolean useToBeDeletedAccessibilityState;
    @NotNull
    private DN baseDN;
    private int maximumAllowedSubtreeSize;
    @Nullable
    private MoveSubtreeListener listener;
    @Nullable
    private OperationPurposeRequestControl operationPurposeRequestControl;

    public MoveSubtreeProperties(@NotNull String baseDN) throws LDAPException {
        this(new DN(baseDN));
    }

    public MoveSubtreeProperties(@NotNull DN baseDN) {
        this.setBaseDN(baseDN);
        this.suppressReferentialIntegrityUpdates = false;
        this.useToBeDeletedAccessibilityState = false;
        this.maximumAllowedSubtreeSize = 0;
        this.listener = null;
        this.operationPurposeRequestControl = null;
    }

    public MoveSubtreeProperties(@NotNull MoveSubtreeProperties properties) {
        this.baseDN = properties.baseDN;
        this.suppressReferentialIntegrityUpdates = properties.suppressReferentialIntegrityUpdates;
        this.useToBeDeletedAccessibilityState = properties.useToBeDeletedAccessibilityState;
        this.maximumAllowedSubtreeSize = properties.maximumAllowedSubtreeSize;
        this.listener = properties.listener;
        this.operationPurposeRequestControl = properties.operationPurposeRequestControl;
    }

    @NotNull
    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(@NotNull String baseDN) throws LDAPException {
        this.setBaseDN(new DN(baseDN));
    }

    public void setBaseDN(@NotNull DN baseDN) {
        Validator.ensureNotNullWithMessage(baseDN, "MoveSubtreeProperties.baseDN must not be null.");
        Validator.ensureTrue(baseDN.getRDNs().length > 0, "MoveSubtreeProperties.baseDN must include one or more RDN components.");
        this.baseDN = baseDN;
    }

    public int getMaximumAllowedSubtreeSize() {
        return this.maximumAllowedSubtreeSize;
    }

    public void setMaximumAllowedSubtreeSize(int sizeLimit) {
        this.maximumAllowedSubtreeSize = sizeLimit > 0 ? sizeLimit : 0;
    }

    public boolean useToBeDeletedAccessibilityState() {
        return this.useToBeDeletedAccessibilityState;
    }

    public void setUseToBeDeletedAccessibilityState(boolean useToBeDeletedState) {
        this.useToBeDeletedAccessibilityState = useToBeDeletedState;
    }

    public boolean suppressReferentialIntegrityUpdates() {
        return this.suppressReferentialIntegrityUpdates;
    }

    public void setSuppressReferentialIntegrityUpdates(boolean suppressUpdates) {
        this.suppressReferentialIntegrityUpdates = suppressUpdates;
    }

    @Nullable
    public OperationPurposeRequestControl getOperationPurposeRequestControl() {
        return this.operationPurposeRequestControl;
    }

    public void setOperationPurposeRequestControl(@Nullable OperationPurposeRequestControl control) {
        this.operationPurposeRequestControl = control;
    }

    @Nullable
    public MoveSubtreeListener getMoveSubtreeListener() {
        return this.listener;
    }

    public void setMoveSubtreeListener(@Nullable MoveSubtreeListener listener) {
        this.listener = listener;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MoveSubtreeProperties(baseDN='");
        buffer.append(this.baseDN);
        buffer.append("', maximumAllowedSubtreeSize=");
        buffer.append(this.maximumAllowedSubtreeSize);
        buffer.append(", useToBeDeletedAccessibilityState=");
        buffer.append(this.useToBeDeletedAccessibilityState);
        buffer.append(", suppressReferentialIntegrityUpdates=");
        buffer.append(this.suppressReferentialIntegrityUpdates);
        buffer.append(", operationPurposeRequestControl=");
        buffer.append(this.operationPurposeRequestControl);
        buffer.append(", moveSubtreeListener=");
        buffer.append(this.listener);
        buffer.append(')');
    }
}

