/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.james.util.MDCStructuredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditTrail {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditTrail.class);

    public static Entry entry() {
        return new Entry();
    }

    public static class Entry {
        Optional<String> username = Optional.empty();
        Optional<String> remoteIP = Optional.empty();
        Optional<String> sessionId = Optional.empty();
        Optional<String> userAgent = Optional.empty();
        Optional<String> protocol = Optional.empty();
        Optional<String> action = Optional.empty();
        Map<String, String> parameters = ImmutableMap.of();

        private Entry() {
        }

        public Entry username(Supplier<String> usernameSupplier) {
            try {
                this.username = Optional.ofNullable(usernameSupplier.get());
            }
            catch (Exception e) {
                LOGGER.warn("Exception while providing AuditTrail username", (Throwable)e);
            }
            return this;
        }

        public Entry remoteIP(Supplier<Optional<InetSocketAddress>> remoteIPSupplier) {
            try {
                this.remoteIP = remoteIPSupplier.get().map(inetSocketAddress -> inetSocketAddress.getAddress().getHostAddress());
            }
            catch (Exception e) {
                LOGGER.warn("Exception while providing AuditTrail remoteIP", (Throwable)e);
            }
            return this;
        }

        public Entry sessionId(Supplier<String> sessionIdSupplier) {
            try {
                this.sessionId = Optional.ofNullable(sessionIdSupplier.get());
            }
            catch (Exception e) {
                LOGGER.warn("Exception while providing AuditTrail sessionId", (Throwable)e);
            }
            return this;
        }

        public Entry userAgent(Supplier<String> userAgentSupplier) {
            try {
                this.userAgent = Optional.ofNullable(userAgentSupplier.get());
            }
            catch (Exception e) {
                LOGGER.warn("Exception while providing AuditTrail userAgent", (Throwable)e);
            }
            return this;
        }

        public Entry protocol(String protocol) {
            this.protocol = Optional.ofNullable(protocol);
            return this;
        }

        public Entry action(String action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        public Entry parameters(Supplier<Map<String, String>> parametersSupplier) {
            try {
                this.parameters = parametersSupplier.get();
            }
            catch (Exception e) {
                LOGGER.warn("Exception while providing AuditTrail parameters", (Throwable)e);
            }
            return this;
        }

        public void log(String message) {
            if (LOGGER.isInfoEnabled()) {
                MDCStructuredLogger mdcStructuredLogger = MDCStructuredLogger.forLogger(LOGGER);
                this.username.ifPresent(value -> mdcStructuredLogger.field("username", (String)value));
                this.remoteIP.ifPresent(value -> mdcStructuredLogger.field("remoteIP", (String)value));
                this.sessionId.ifPresent(value -> mdcStructuredLogger.field("sessionId", (String)value));
                this.userAgent.ifPresent(value -> mdcStructuredLogger.field("userAgent", (String)value));
                this.protocol.ifPresent(value -> mdcStructuredLogger.field("protocol", (String)value));
                this.action.ifPresent(value -> mdcStructuredLogger.field("action", (String)value));
                this.parameters.forEach(mdcStructuredLogger::field);
                mdcStructuredLogger.log((Logger logger) -> logger.info(message));
            }
        }
    }
}

