/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.mailet.filter.ContentMatcher;
import org.apache.james.jmap.mailet.filter.HeaderExtractor;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MailMatcher {
    public static MailMatcher from(Rule rule) {
        return new HeaderMatcher((List)rule.getConditionGroup().getConditions().stream().map(ruleCondition -> new MailMatchingCondition(ContentMatcher.asContentMatcher(ruleCondition.getField(), ruleCondition.getComparator()).orElseThrow(() -> new RuntimeException("No content matcher associated with field " + String.valueOf(ruleCondition.getField()))), ruleCondition.getValue(), HeaderExtractor.asHeaderExtractor(ruleCondition.getField()).orElseThrow(() -> new RuntimeException("No content matcher associated with comparator " + String.valueOf(ruleCondition.getComparator()))))).collect(ImmutableList.toImmutableList()), rule.getConditionGroup().getConditionCombiner());
    }

    public boolean match(Mail var1);

    public static class HeaderMatcher
    implements MailMatcher {
        private static final Logger LOGGER = LoggerFactory.getLogger(HeaderMatcher.class);
        private List<MailMatchingCondition> mailMatchingConditions;
        private final Rule.ConditionCombiner conditionCombiner;

        private HeaderMatcher(List<MailMatchingCondition> mailMatchingConditions, Rule.ConditionCombiner conditionCombiner) {
            this.mailMatchingConditions = mailMatchingConditions;
            this.conditionCombiner = conditionCombiner;
        }

        @Override
        public boolean match(Mail mail) {
            try {
                Predicate predicate = mailMatchingCondition -> {
                    Stream headerLines = (Stream)mailMatchingCondition.getHeaderExtractor().apply(mail);
                    return mailMatchingCondition.getContentMatcher().match(headerLines, mailMatchingCondition.getRuleValue());
                };
                switch (this.conditionCombiner) {
                    case AND: {
                        return this.mailMatchingConditions.stream().allMatch(predicate);
                    }
                    case OR: {
                        return this.mailMatchingConditions.stream().anyMatch(predicate);
                    }
                }
                throw new Exception(String.valueOf(this.conditionCombiner) + " conditionCombiner is not supported");
            }
            catch (Exception e) {
                LOGGER.error("error while extracting mail header", (Throwable)e);
                return false;
            }
        }
    }

    public static class MailMatchingCondition {
        private final ContentMatcher contentMatcher;
        private final String ruleValue;
        private final HeaderExtractor headerExtractor;

        private MailMatchingCondition(ContentMatcher contentMatcher, String ruleValue, HeaderExtractor headerExtractor) {
            Preconditions.checkNotNull((Object)contentMatcher);
            Preconditions.checkNotNull((Object)headerExtractor);
            this.contentMatcher = contentMatcher;
            this.ruleValue = ruleValue;
            this.headerExtractor = headerExtractor;
        }

        public ContentMatcher getContentMatcher() {
            return this.contentMatcher;
        }

        public String getRuleValue() {
            return this.ruleValue;
        }

        public HeaderExtractor getHeaderExtractor() {
            return this.headerExtractor;
        }
    }
}

