/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.mail.MDNSendAlreadySentException;
import org.apache.james.jmap.mail.MDNSendCreateResponse;
import org.apache.james.jmap.mail.MDNSendCreateSuccess;
import org.apache.james.jmap.mail.MDNSendCreationId;
import org.apache.james.jmap.mail.MDNSendForbiddenException;
import org.apache.james.jmap.mail.MDNSendForbiddenFromException;
import org.apache.james.jmap.mail.MDNSendInvalidPropertiesException;
import org.apache.james.jmap.mail.MDNSendNotFoundException;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException;
import org.apache.james.jmap.mail.MDNSendResults;
import org.apache.james.mailbox.model.MessageId;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class MDNSendResults$
implements Serializable {
    public static final MDNSendResults$ MODULE$ = new MDNSendResults$();

    public MDNSendResults empty() {
        return new MDNSendResults((Option<Map<MDNSendCreationId, MDNSendCreateResponse>>)None$.MODULE$, (Option<Map<MDNSendCreationId, SetError>>)None$.MODULE$, (Map<MDNSendCreationId, MessageId>)Predef$.MODULE$.Map().empty());
    }

    public MDNSendResults sent(MDNSendCreateSuccess createSuccess) {
        return new MDNSendResults((Option<Map<MDNSendCreationId, MDNSendCreateResponse>>)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)createSuccess.mdnCreationId()), (Object)createSuccess.createResponse())}))), (Option<Map<MDNSendCreationId, SetError>>)None$.MODULE$, (Map<MDNSendCreationId, MessageId>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)createSuccess.mdnCreationId()), (Object)createSuccess.forEmailId())}))));
    }

    public MDNSendResults notSent(MDNSendCreationId mdnSendId, Throwable throwable) {
        SetError setError;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof MDNSendNotFoundException) {
            MDNSendNotFoundException mDNSendNotFoundException = (MDNSendNotFoundException)throwable2;
            setError = SetError$.MODULE$.notFound(mDNSendNotFoundException.description());
        } else if (throwable2 instanceof MDNSendForbiddenException) {
            setError = new SetError(SetError$.MODULE$.forbiddenValue(), "Violate an Access Control List (ACL) or other permissions policy.", (Option<Properties>)None$.MODULE$);
        } else if (throwable2 instanceof MDNSendForbiddenFromException) {
            MDNSendForbiddenFromException mDNSendForbiddenFromException = (MDNSendForbiddenFromException)throwable2;
            setError = new SetError(SetError$.MODULE$.forbiddenFromValue(), mDNSendForbiddenFromException.description(), (Option<Properties>)None$.MODULE$);
        } else if (throwable2 instanceof MDNSendInvalidPropertiesException) {
            setError = new SetError(SetError$.MODULE$.invalidArgumentValue(), "The record given is invalid in some way.", (Option<Properties>)None$.MODULE$);
        } else if (throwable2 instanceof MDNSendAlreadySentException) {
            setError = SetError$.MODULE$.mdnAlreadySent("The message has the $mdnsent keyword already set.");
        } else if (throwable2 instanceof MDNSendRequestInvalidException) {
            MDNSendRequestInvalidException mDNSendRequestInvalidException = (MDNSendRequestInvalidException)throwable2;
            setError = mDNSendRequestInvalidException.error();
        } else {
            throw new MatchError((Object)throwable2);
        }
        SetError setError2 = setError;
        return new MDNSendResults((Option<Map<MDNSendCreationId, MDNSendCreateResponse>>)None$.MODULE$, (Option<Map<MDNSendCreationId, SetError>>)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mdnSendId), (Object)setError2)}))), (Map<MDNSendCreationId, MessageId>)Predef$.MODULE$.Map().empty());
    }

    public MDNSendResults merge(MDNSendResults result1, MDNSendResults result2) {
        return new MDNSendResults((Option<Map<MDNSendCreationId, MDNSendCreateResponse>>)((IterableOnceOps)Option$.MODULE$.option2Iterable(result1.sent()).$plus$plus(result2.sent())).reduceOption((Function2 & Serializable)(x$8, x$9) -> (Map)x$8.$plus$plus((IterableOnce)x$9)), (Option<Map<MDNSendCreationId, SetError>>)((IterableOnceOps)Option$.MODULE$.option2Iterable(result1.notSent()).$plus$plus(result2.notSent())).reduceOption((Function2 & Serializable)(x$10, x$11) -> (Map)x$10.$plus$plus((IterableOnce)x$11)), (Map<MDNSendCreationId, MessageId>)((Map)result1.mdnSentIdResolver().$plus$plus(result2.mdnSentIdResolver())));
    }

    public MDNSendResults apply(Option<Map<MDNSendCreationId, MDNSendCreateResponse>> sent, Option<Map<MDNSendCreationId, SetError>> notSent, Map<MDNSendCreationId, MessageId> mdnSentIdResolver) {
        return new MDNSendResults(sent, notSent, mdnSentIdResolver);
    }

    public Option<Tuple3<Option<Map<MDNSendCreationId, MDNSendCreateResponse>>, Option<Map<MDNSendCreationId, SetError>>, Map<MDNSendCreationId, MessageId>>> unapply(MDNSendResults x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3(x$0.sent(), x$0.notSent(), x$0.mdnSentIdResolver()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MDNSendResults$.class);
    }

    private MDNSendResults$() {
    }
}

