/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.codec.PostgresqlTimeFormatter;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Map;

class PostgresqlDateTimeFormatter {
    private static final String NEGATIVE_INFINITY = "-infinity";
    private static final String INFINITY = "infinity";
    private static final LocalDate MIN_LOCAL_DATE = LocalDate.of(4713, 1, 1).with(ChronoField.ERA, IsoEra.BCE.getValue());
    private static final LocalDateTime MIN_LOCAL_DATETIME = MIN_LOCAL_DATE.atStartOfDay();
    private static final OffsetDateTime MIN_OFFSET_DATETIME = MIN_LOCAL_DATETIME.atOffset(ZoneOffset.UTC);
    private static final LocalDate MAX_LOCAL_DATE = LocalDate.of(5874897, 12, 31);
    private static final OffsetDateTime MAX_OFFSET_DATETIME = OffsetDateTime.MAX.minus(Duration.ofMillis(500L));
    private static final LocalDateTime MAX_LOCAL_DATETIME = LocalDateTime.MAX.minus(Duration.ofMillis(500L));
    private static final DateTimeFormatter DATE_TIME_BACKEND = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA, 4, 10, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendOffset("+HH:MM:ss", "+00:00:00").optionalEnd().optionalStart().appendOffset("+HH:MM", "+00:00").optionalEnd().optionalStart().appendOffset("+HH", "+00").optionalEnd().optionalStart().appendLiteral(' ').appendText((TemporalField)ChronoField.ERA, PostgresqlDateTimeFormatter.createMapping()).optionalEnd().toFormatter();
    private static final DateTimeFormatter DATE_BACKEND = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA, 4, 10, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendLiteral(' ').appendText((TemporalField)ChronoField.ERA, PostgresqlDateTimeFormatter.createMapping()).optionalEnd().toFormatter();

    PostgresqlDateTimeFormatter() {
    }

    private static Map<Long, String> createMapping() {
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(0L, "BC");
        map.put(1L, "AC");
        return map;
    }

    static LocalDate parseLocalDate(String localDate) {
        if (PostgresqlDateTimeFormatter.isInfinity(localDate)) {
            return LocalDate.MAX;
        }
        if (PostgresqlDateTimeFormatter.isNegativeInfinity(localDate)) {
            return LocalDate.MIN;
        }
        return DATE_BACKEND.parse((CharSequence)localDate, LocalDate::from);
    }

    public static String toString(LocalDate localDate) {
        if (localDate.isAfter(MAX_LOCAL_DATE)) {
            return INFINITY;
        }
        if (localDate.isBefore(MIN_LOCAL_DATE)) {
            return NEGATIVE_INFINITY;
        }
        StringBuilder sbuf = new StringBuilder(10);
        PostgresqlDateTimeFormatter.appendDate(sbuf, localDate);
        PostgresqlDateTimeFormatter.appendEra(sbuf, localDate);
        return sbuf.toString();
    }

    static LocalDateTime parseLocalDateTime(String localDateTime) {
        if (PostgresqlDateTimeFormatter.isInfinity(localDateTime)) {
            return LocalDateTime.MAX;
        }
        if (PostgresqlDateTimeFormatter.isNegativeInfinity(localDateTime)) {
            return LocalDateTime.MIN;
        }
        return DATE_TIME_BACKEND.parse((CharSequence)localDateTime, LocalDateTime::from);
    }

    static String toString(LocalDateTime localDateTime) {
        if (localDateTime.isAfter(MAX_LOCAL_DATETIME)) {
            return INFINITY;
        }
        if (localDateTime.isBefore(MIN_LOCAL_DATETIME)) {
            return NEGATIVE_INFINITY;
        }
        StringBuilder sbuf = new StringBuilder(24);
        int nano = localDateTime.getNano();
        if (PostgresqlTimeFormatter.nanosExceed499(nano)) {
            localDateTime = localDateTime.plus(PostgresqlTimeFormatter.ONE_MICROSECOND);
        }
        LocalDate localDate = localDateTime.toLocalDate();
        PostgresqlDateTimeFormatter.appendDate(sbuf, localDate);
        sbuf.append(' ');
        PostgresqlTimeFormatter.appendTime(sbuf, localDateTime.toLocalTime());
        PostgresqlDateTimeFormatter.appendEra(sbuf, localDate);
        return sbuf.toString();
    }

    static OffsetDateTime parseOffsetDateTime(String offsetDateTime) {
        if (PostgresqlDateTimeFormatter.isInfinity(offsetDateTime)) {
            return OffsetDateTime.MAX;
        }
        if (PostgresqlDateTimeFormatter.isNegativeInfinity(offsetDateTime)) {
            return OffsetDateTime.MIN;
        }
        return DATE_TIME_BACKEND.parse((CharSequence)offsetDateTime, OffsetDateTime::from);
    }

    static String toString(OffsetDateTime offsetDateTime) {
        if (offsetDateTime.isAfter(MAX_OFFSET_DATETIME)) {
            return INFINITY;
        }
        if (offsetDateTime.isBefore(MIN_OFFSET_DATETIME)) {
            return NEGATIVE_INFINITY;
        }
        StringBuilder sbuf = new StringBuilder(24);
        int nano = offsetDateTime.getNano();
        if (PostgresqlTimeFormatter.nanosExceed499(nano)) {
            offsetDateTime = offsetDateTime.plus(PostgresqlTimeFormatter.ONE_MICROSECOND);
        }
        LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        PostgresqlDateTimeFormatter.appendDate(sbuf, localDate);
        sbuf.append(' ');
        PostgresqlTimeFormatter.appendTime(sbuf, localDateTime.toLocalTime());
        PostgresqlTimeFormatter.appendTimeZone(sbuf, offsetDateTime.getOffset());
        PostgresqlDateTimeFormatter.appendEra(sbuf, localDate);
        return sbuf.toString();
    }

    static String toString(Instant instant) {
        if (instant.isAfter(MAX_OFFSET_DATETIME.toInstant())) {
            return INFINITY;
        }
        if (instant.isBefore(MIN_OFFSET_DATETIME.toInstant())) {
            return NEGATIVE_INFINITY;
        }
        return PostgresqlDateTimeFormatter.toString(instant.atOffset(ZoneOffset.UTC));
    }

    private static void appendDate(StringBuilder sb, LocalDate localDate) {
        int year = localDate.get(ChronoField.YEAR_OF_ERA);
        int month = localDate.getMonthValue();
        int day = localDate.getDayOfMonth();
        PostgresqlDateTimeFormatter.appendDate(sb, year, month, day);
    }

    private static void appendDate(StringBuilder sb, int year, int month, int day) {
        int prevLength = sb.length();
        sb.append(year);
        int leadingZerosForYear = 4 - (sb.length() - prevLength);
        if (leadingZerosForYear > 0) {
            sb.insert(prevLength, PostgresqlTimeFormatter.ZEROS, 0, leadingZerosForYear);
        }
        sb.append('-');
        sb.append(PostgresqlTimeFormatter.NUMBERS[month]);
        sb.append('-');
        sb.append(PostgresqlTimeFormatter.NUMBERS[day]);
    }

    private static void appendEra(StringBuilder sb, LocalDate localDate) {
        if (localDate.get(ChronoField.ERA) == IsoEra.BCE.getValue()) {
            sb.append(" BC");
        }
    }

    private static boolean isNegativeInfinity(String localDateTime) {
        return localDateTime.length() == 9 && localDateTime.equals(NEGATIVE_INFINITY);
    }

    private static boolean isInfinity(String localDateTime) {
        return localDateTime.length() == 8 && localDateTime.equals(INFINITY) || localDateTime.length() == 9 && localDateTime.equals("+infinity");
    }
}

