/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.table.CassandraAttachmentV2Table;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.model.MessageId;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraAttachmentDAOV2 {
    private final BlobId.Factory blobIdFactory;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertStatement;
    private final PreparedStatement insertMessageIdStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectStatement;
    private final PreparedStatement listBlobs;
    private final CqlSession session;

    public static DAOAttachment from(AttachmentMetadata attachment, BlobId blobId) {
        return new DAOAttachment(attachment.getMessageId(), attachment.getAttachmentId(), blobId, attachment.getType(), attachment.getSize());
    }

    private static Mono<DAOAttachment> fromRow(Row row, BlobId.Factory blobIfFactory, Mono<CassandraMessageId> fallback) {
        return Optional.ofNullable(row.getUuid(CassandraAttachmentV2Table.MESSAGE_ID)).map(CassandraMessageId.Factory::of).map(Mono::just).orElse(fallback).map(messageIdAsUUid -> new DAOAttachment((MessageId)messageIdAsUUid, AttachmentId.from((String)row.getString(CassandraAttachmentV2Table.ID)), blobIfFactory.from(row.getString(CassandraAttachmentV2Table.BLOB_ID)), ContentType.of((String)row.getString(CassandraAttachmentV2Table.TYPE)), row.getLong(CassandraAttachmentV2Table.SIZE)));
    }

    @Inject
    public CassandraAttachmentDAOV2(BlobId.Factory blobIdFactory, CqlSession session) {
        this.session = session;
        this.blobIdFactory = blobIdFactory;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.selectStatement = this.prepareSelect();
        this.insertStatement = this.prepareInsert();
        this.deleteStatement = this.prepareDelete();
        this.listBlobs = this.prepareSelectBlobs();
        this.insertMessageIdStatement = this.prepareInsertMessageId();
    }

    private PreparedStatement prepareSelectBlobs() {
        return this.session.prepare(QueryBuilder.selectFrom((String)"attachmentV2").column(CassandraAttachmentV2Table.BLOB_ID).build());
    }

    private PreparedStatement prepareDelete() {
        return this.session.prepare(((Delete)QueryBuilder.deleteFrom((String)"attachmentV2").where((Relation)Relation.column((CqlIdentifier)CassandraAttachmentV2Table.ID_AS_UUID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.ID_AS_UUID)))).build());
    }

    private PreparedStatement prepareInsert() {
        return this.session.prepare(QueryBuilder.insertInto((String)"attachmentV2").value(CassandraAttachmentV2Table.ID_AS_UUID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.ID_AS_UUID)).value(CassandraAttachmentV2Table.ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.ID)).value(CassandraAttachmentV2Table.BLOB_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.BLOB_ID)).value(CassandraAttachmentV2Table.TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.TYPE)).value(CassandraAttachmentV2Table.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.MESSAGE_ID)).value(CassandraAttachmentV2Table.SIZE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.SIZE)).build());
    }

    private PreparedStatement prepareInsertMessageId() {
        return this.session.prepare(QueryBuilder.insertInto((String)"attachmentV2").value(CassandraAttachmentV2Table.ID_AS_UUID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.ID_AS_UUID)).value(CassandraAttachmentV2Table.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.MESSAGE_ID)).build());
    }

    private PreparedStatement prepareSelect() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"attachmentV2").columns(CassandraAttachmentV2Table.FIELDS).where((Relation)Relation.column((CqlIdentifier)CassandraAttachmentV2Table.ID_AS_UUID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraAttachmentV2Table.ID_AS_UUID)))).build());
    }

    public Mono<DAOAttachment> getAttachment(AttachmentId attachmentId, Mono<CassandraMessageId> fallback) {
        Preconditions.checkArgument((attachmentId != null ? 1 : 0) != 0);
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectStatement.bind(new Object[0]).setUuid(CassandraAttachmentV2Table.ID_AS_UUID, attachmentId.asUUID())).flatMap(row -> CassandraAttachmentDAOV2.fromRow(row, this.blobIdFactory, fallback));
    }

    public Mono<Void> storeAttachment(DAOAttachment attachment) {
        CassandraMessageId messageId = (CassandraMessageId)attachment.getMessageId();
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setUuid(CassandraAttachmentV2Table.ID_AS_UUID, attachment.getAttachmentId().asUUID())).setString(CassandraAttachmentV2Table.ID, attachment.getAttachmentId().getId())).setLong(CassandraAttachmentV2Table.SIZE, attachment.getSize())).setUuid(CassandraAttachmentV2Table.MESSAGE_ID, messageId.get())).setString(CassandraAttachmentV2Table.TYPE, attachment.getType().asString())).setString(CassandraAttachmentV2Table.BLOB_ID, attachment.getBlobId().asString()));
    }

    public Mono<Void> insertMessageId(AttachmentId attachmentId, MessageId messageId) {
        CassandraMessageId cassandraMessageId = (CassandraMessageId)messageId;
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.insertMessageIdStatement.bind(new Object[0]).setUuid(CassandraAttachmentV2Table.ID_AS_UUID, attachmentId.asUUID())).setUuid(CassandraAttachmentV2Table.MESSAGE_ID, cassandraMessageId.get()));
    }

    public Mono<Void> delete(AttachmentId attachmentId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraAttachmentV2Table.ID_AS_UUID, attachmentId.asUUID()));
    }

    public Flux<BlobId> listBlobs() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listBlobs.bind(new Object[0])).map(row -> this.blobIdFactory.from(row.getString(CassandraAttachmentV2Table.BLOB_ID)));
    }

    public static class DAOAttachment {
        private final MessageId messageId;
        private final AttachmentId attachmentId;
        private final BlobId blobId;
        private final ContentType type;
        private final long size;

        DAOAttachment(MessageId messageId, AttachmentId attachmentId, BlobId blobId, ContentType type, long size) {
            this.messageId = messageId;
            this.attachmentId = attachmentId;
            this.blobId = blobId;
            this.type = type;
            this.size = size;
        }

        public AttachmentId getAttachmentId() {
            return this.attachmentId;
        }

        public BlobId getBlobId() {
            return this.blobId;
        }

        public ContentType getType() {
            return this.type;
        }

        public long getSize() {
            return this.size;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public AttachmentMetadata toAttachment() {
            return AttachmentMetadata.builder().attachmentId(this.attachmentId).type(this.type).size(this.size).messageId(this.messageId).build();
        }

        public final boolean equals(Object o) {
            if (o instanceof DAOAttachment) {
                DAOAttachment that = (DAOAttachment)o;
                return Objects.equals(this.size, that.size) && Objects.equals(this.attachmentId, that.attachmentId) && Objects.equals(this.blobId, that.blobId) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.type, that.type);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.attachmentId, this.blobId, this.type, this.size, this.messageId);
        }
    }
}

