/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.model.MailboxCreationId;
import org.apache.james.jmap.draft.model.mailbox.MailboxCreateRequest;
import org.apache.james.jmap.draft.model.mailbox.MailboxUpdateRequest;
import org.apache.james.mailbox.model.MailboxId;

@JsonDeserialize(builder=Builder.class)
public class SetMailboxesRequest
implements JmapRequest {
    private final ImmutableMap<MailboxCreationId, MailboxCreateRequest> create;
    private final ImmutableMap<MailboxId, MailboxUpdateRequest> update;
    private final ImmutableList<MailboxId> destroy;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    SetMailboxesRequest(ImmutableMap<MailboxCreationId, MailboxCreateRequest> create, ImmutableMap<MailboxId, MailboxUpdateRequest> update, ImmutableList<MailboxId> destroy) {
        this.create = create;
        this.update = update;
        this.destroy = destroy;
    }

    public ImmutableMap<MailboxCreationId, MailboxCreateRequest> getCreate() {
        return this.create;
    }

    public ImmutableMap<MailboxId, MailboxUpdateRequest> getUpdate() {
        return this.update;
    }

    public ImmutableList<MailboxId> getDestroy() {
        return this.destroy;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private final ImmutableMap.Builder<MailboxCreationId, MailboxCreateRequest> create = ImmutableMap.builder();
        private final ImmutableMap.Builder<MailboxId, MailboxUpdateRequest> update = ImmutableMap.builder();
        private final ImmutableList.Builder<MailboxId> destroy = ImmutableList.builder();

        private Builder() {
        }

        public Builder create(Map<MailboxCreationId, MailboxCreateRequest> requests) {
            this.create.putAll(requests);
            return this;
        }

        public Builder create(MailboxCreationId creationId, MailboxCreateRequest mailbox) {
            this.create.put((Object)creationId, (Object)mailbox);
            return this;
        }

        public Builder accountId(String accountId) {
            throw new NotImplementedException("not implemented");
        }

        public Builder ifInState(String state) {
            throw new NotImplementedException("not implemented");
        }

        public Builder update(MailboxId mailboxId, MailboxUpdateRequest mailboxUpdateRequest) {
            this.update.put((Object)mailboxId, (Object)mailboxUpdateRequest);
            return this;
        }

        public Builder update(Map<MailboxId, MailboxUpdateRequest> updates) {
            this.update.putAll(updates);
            return this;
        }

        public Builder destroy(List<MailboxId> deletions) {
            this.destroy.addAll(deletions);
            return this;
        }

        public SetMailboxesRequest build() {
            return new SetMailboxesRequest((ImmutableMap<MailboxCreationId, MailboxCreateRequest>)this.create.build(), (ImmutableMap<MailboxId, MailboxUpdateRequest>)this.update.build(), (ImmutableList<MailboxId>)this.destroy.build());
        }
    }
}

