/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.MailboxChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.change.AccountIdRegistrationKey$;
import org.apache.james.jmap.change.EmailTypeName$;
import org.apache.james.jmap.change.MailboxTypeName$;
import org.apache.james.jmap.change.StateChangeListener;
import org.apache.james.jmap.change.TypeState;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.OutboundMessage;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.PushState;
import org.apache.james.jmap.core.PushState$;
import org.apache.james.jmap.core.RequestId;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.core.StateChange;
import org.apache.james.jmap.core.UuidState;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.core.WebSocketError;
import org.apache.james.jmap.core.WebSocketInboundMessage;
import org.apache.james.jmap.core.WebSocketPushDisable$;
import org.apache.james.jmap.core.WebSocketPushEnable;
import org.apache.james.jmap.core.WebSocketRequest;
import org.apache.james.jmap.core.WebSocketResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.PushSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.ClientContext;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.WebSocketRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUs!B\r\u001b\u0011\u0003)c!B\u0014\u001b\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007s\u0005\u0001\u000b\u0011B\u001a\u0007\t\u001dR\u0002A\u000f\u0005\t\u000f\u0016\u0011)\u0019!C\u0001\u0011\"Aq*\u0002B\u0001B\u0003%\u0011\n\u0003\u0005Q\u000b\t\u0005\t\u0015!\u0003R\u0011!!VA!A!\u0002\u0013)\u0006\u0002C4\u0006\u0005\u0003\u0005\u000b\u0011\u00025\t\u0011-,!\u0011!Q\u0001\n1D\u0001\u0002^\u0003\u0003\u0002\u0003\u0006I!\u001e\u0005\tq\u0016\u0011\t\u0011)A\u0005s\"Iq0\u0002B\u0001B\u0003%\u0011\u0011\u0001\u0005\u0007_\u0015!\t!a\u0002\t\rm)A\u0011IA\u0016\u0011\u001d\t\u0019%\u0002C\u0005\u0003\u000bBq!!!\u0006\t\u0013\t\u0019\tC\u0004\u00022\u0016!I!a-\t\u000f\u0005EX\u0001\"\u0003\u0002t\"9!\u0011A\u0003\u0005\n\t\r\u0001b\u0002B\u0004\u000b\u0011%!\u0011\u0002\u0005\b\u0005O)A\u0011\u0002B\u0015\u0011\u001d\u0011)%\u0002C\u0005\u0005\u000f\nqbV3c'>\u001c7.\u001a;S_V$Xm\u001d\u0006\u00037q\taA]8vi\u0016\u001c(BA\u000f\u001f\u0003\u0011QW.\u00199\u000b\u0005}\u0001\u0013!\u00026b[\u0016\u001c(BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002'\u00035\t!DA\bXK\n\u001cvnY6fiJ{W\u000f^3t'\t\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\na\u0001T(H\u000f\u0016\u0013V#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\u0012\u0013!B:mMRR\u0017B\u0001\u001d6\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u00033cA\u0003<\u0007B\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$AB(cU\u0016\u001cG\u000f\u0005\u0002E\u000b6\tA$\u0003\u0002G9\tQ!*T!Q%>,H/Z:\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u001d\u0003\u0011AG\u000f\u001e9\n\u00059[%!D!vi\",g\u000e^5dCR|'/\u0001\bbkRDWM\u001c;jG\u0006$xN\u001d\u0011\u0002\u001fU\u001cXM\u001d)s_ZL7/[8oKJ\u0004\"A\u0013*\n\u0005M[%\u0001E+tKJ\u0004&o\u001c<jg&|g.\u001b8h\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001,Z\u001b\u00059&B\u0001-\u001f\u0003\u0019)g/\u001a8ug&\u0011!l\u0016\u0002\t\u000bZ,g\u000e\u001e\"vg\"\"\u0011\u0002\u00183f!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0004j]*,7\r\u001e\u0006\u0002C\u0006)!.\u0019<bq&\u00111M\u0018\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002M\u0006!!*T!Q\u0003\u001dQW.\u00199Ba&\u0004\"AJ5\n\u0005)T\"a\u0002&N\u0003B\u000b\u0005/[\u0001\u0018[\u0006LGNY8y\u0007\"\fgnZ3SKB|7/\u001b;pef\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\r\rD\u0017M\\4f\u0015\t\tH$A\u0002ba&L!a\u001d8\u0003/5\u000b\u0017\u000e\u001c2pq\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\u0018!F3nC&d7\t[1oO\u0016\u0014V\r]8tSR|'/\u001f\t\u0003[ZL!a\u001e8\u0003+\u0015k\u0017-\u001b7DQ\u0006tw-\u001a*fa>\u001c\u0018\u000e^8ss\u0006q\u0001/^:i'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001>~\u001b\u0005Y(B\u0001?\u001d\u0003\u0011Q7o\u001c8\n\u0005y\\(A\u0004)vg\"\u001cVM]5bY&TXM]\u0001\u0011if\u0004Xm\u0015;bi\u00164\u0015m\u0019;pef\u00042!\\A\u0002\u0013\r\t)A\u001c\u0002\u0011)f\u0004Xm\u0015;bi\u00164\u0015m\u0019;pef$\"#!\u0003\u0002\f\u0005M\u0011QCA\r\u00037\ti\"a\b\u0002\"A\u0011a%\u0002\u0005\u0006\u000f>\u0001\r!\u0013\u0015\u0007\u0003\u0017aF-a\u0004\"\u0005\u0005E\u0011\u0001\u0003*G\u00076BdGM\u0019\t\u000bA{\u0001\u0019A)\t\u000bQ{\u0001\u0019A+)\u000b\u0005UA\fZ3\t\u000b\u001d|\u0001\u0019\u00015\t\u000b-|\u0001\u0019\u00017\t\u000bQ|\u0001\u0019A;\t\u000ba|\u0001\u0019A=\t\r}|\u0001\u0019AA\u0001Q\ry\u0011Q\u0005\t\u0004;\u0006\u001d\u0012bAA\u0015=\n1\u0011J\u001c6fGR$\"!!\f\u0011\r\u0005=\u0012\u0011HA\u001f\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012AB:ue\u0016\fWNC\u0002\u00028}\nA!\u001e;jY&!\u00111HA\u0019\u0005\u0019\u0019FO]3b[B\u0019A)a\u0010\n\u0007\u0005\u0005CDA\u0005K\u001b\u0006\u0003&k\\;uK\u0006\u0001\u0002.\u00198eY\u0016<VMY*pG.,Go\u001d\u000b\u0007\u0003\u000f\n\t'a\u001e\u0011\r\u0005%\u0013qKA.\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!\u00039vE2L7\u000f[3s\u0015\u0011\t\t&a\u0015\u0002\t\r|'/\u001a\u0006\u0003\u0003+\nqA]3bGR|'/\u0003\u0003\u0002Z\u0005-#\u0001B'p]>\u00042\u0001PA/\u0013\r\ty&\u0010\u0002\u0005->LG\rC\u0004\u0002dE\u0001\r!!\u001a\u0002#!$H\u000f]*feZ,'OU3rk\u0016\u001cH\u000f\u0005\u0003\u0002h\u0005MTBAA5\u0015\u0011\tY'!\u001c\u0002\rM,'O^3s\u0015\ra\u0015q\u000e\u0006\u0005\u0003c\n\u0019&A\u0003oKR$\u00180\u0003\u0003\u0002v\u0005%$!\u0005%uiB\u001cVM\u001d<feJ+\u0017/^3ti\"9\u0011\u0011P\tA\u0002\u0005m\u0014A\u00055uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016\u0004B!a\u001a\u0002~%!\u0011qPA5\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\u00023!\fg\u000e\u001a7f/\u0016\u00147k\\2lKR\u001cuN\u001c8fGRLwN\u001c\u000b\u0005\u0003\u000b\u000b\t\u000b\u0006\u0004\u0002H\u0005\u001d\u0015q\u0013\u0005\b\u0003\u0013\u0013\u0002\u0019AAF\u0003\tIg\u000e\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\u0011\t\t*!\u001c\u0002\u0013],'m]8dW\u0016$\u0018\u0002BAK\u0003\u001f\u0013\u0001cV3cg>\u001c7.\u001a;J]\n|WO\u001c3\t\u000f\u0005e%\u00031\u0001\u0002\u001c\u0006\u0019q.\u001e;\u0011\t\u00055\u0015QT\u0005\u0005\u0003?\u000byIA\tXK\n\u001cxnY6fi>+HOY8v]\u0012Dq!a)\u0013\u0001\u0004\t)+A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SS1!a+\u001f\u0003\u001di\u0017-\u001b7c_bLA!a,\u0002*\nqQ*Y5mE>D8+Z:tS>t\u0017\u0001\u00065b]\u0012dWm\u00117jK:$X*Z:tC\u001e,7\u000f\u0006\u0003\u00026\u0006\u001dH\u0003BA\\\u0003\u001b\u0004b!!/\u0002@\u0006\rWBAA^\u0015\u0011\ti%!0\u000b\u00071\ny%\u0003\u0003\u0002B\u0006m&!B*N_:|\u0007\u0003BAc\u0003\u0013l!!a2\u000b\u0007\u0005EC$\u0003\u0003\u0002L\u0006\u001d'aD(vi\n|WO\u001c3NKN\u001c\u0018mZ3\t\u000f\u0005=7\u00031\u0001\u0002R\u00069Q.Z:tC\u001e,\u0007\u0003BAj\u0003CtA!!6\u0002^B\u0019\u0011q[\u0016\u000e\u0005\u0005e'bAAnI\u00051AH]8pizJ1!a8,\u0003\u0019\u0001&/\u001a3fM&!\u00111]As\u0005\u0019\u0019FO]5oO*\u0019\u0011q\\\u0016\t\u000f\u0005%8\u00031\u0001\u0002l\u0006i1\r\\5f]R\u001cuN\u001c;fqR\u00042AJAw\u0013\r\tyO\u0007\u0002\u000e\u00072LWM\u001c;D_:$X\r\u001f;\u00021M,g\u000e\u001a)vg\"\u001cF/\u0019;f\u0013\u001a\u0014V-];fgR,G\r\u0006\u0004\u00028\u0006U\u0018q \u0005\b\u0003o$\u0002\u0019AA}\u0003)\u0001Xo\u001d5F]\u0006\u0014G.\u001a\t\u0005\u0003\u000b\fY0\u0003\u0003\u0002~\u0006\u001d'aE,fEN{7m[3u!V\u001c\b.\u00128bE2,\u0007bBAu)\u0001\u0007\u00111^\u0001\u000eg\u0016tG\rU;tQN#\u0018\r^3\u0015\t\u0005]&Q\u0001\u0005\b\u0003S,\u0002\u0019AAv\u0003aA\u0017M\u001c3mK\"#H\u000f\u001d%b]\u0012\u001c\b.Y6f\u000bJ\u0014xN\u001d\u000b\u0007\u0005\u0017\u0011iAa\t\u0011\r\u0005e\u0016qXA.\u0011\u001d\u0011yA\u0006a\u0001\u0005#\t\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\tM!Q\u0004\b\u0005\u0005+\u0011IB\u0004\u0003\u0002X\n]\u0011\"\u0001\u0017\n\u0007\tm1&A\u0004qC\u000e\\\u0017mZ3\n\t\t}!\u0011\u0005\u0002\n)\"\u0014xn^1cY\u0016T1Aa\u0007,\u0011\u001d\u0011)C\u0006a\u0001\u0003w\n\u0001B]3ta>t7/Z\u0001\bCN,%O]8s)\u0011\u0011YC!\u000e\u0015\t\t5\"1\u0007\t\u0005\u0003\u000b\u0014y#\u0003\u0003\u00032\u0005\u001d'AD,fEN{7m[3u\u000bJ\u0014xN\u001d\u0005\b\u0005\u001f9\u0002\u0019\u0001B\t\u0011\u001d\u00119d\u0006a\u0001\u0005s\t\u0011B]3rk\u0016\u001cH/\u00133\u0011\u000b)\u0012YDa\u0010\n\u0007\tu2F\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000b\u0014\t%\u0003\u0003\u0003D\u0005\u001d'!\u0003*fcV,7\u000f^%e\u00039\u0011Xm\u001d9p]\u0012$U\r^1jYN$bAa\u0003\u0003J\t-\u0003bBA=1\u0001\u0007\u00111\u0010\u0005\b\u0005\u001bB\u0002\u0019\u0001B(\u0003\u001d!W\r^1jYN\u0004B!!2\u0003R%!!1KAd\u00059\u0001&o\u001c2mK6$U\r^1jYN\u0004")
public class WebSocketRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    @Named(value="JMAP")
    private final EventBus eventBus;
    private final JMAPApi jmapApi;
    private final MailboxChangeRepository mailboxChangeRepository;
    private final EmailChangeRepository emailChangeRepository;
    private final PushSerializer pushSerializer;
    private final TypeStateFactory typeStateFactory;

    public static Logger LOGGER() {
        return WebSocketRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, "/jmap/ws")).action((httpServerRequest, httpServerResponse) -> this.handleWebSockets(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/jmap/ws")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> handleWebSockets(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(SMono$.MODULE$.apply((Publisher)httpServerResponse.sendWebsocket((in, out) -> this.handleWebSocketConnection((MailboxSession)mailboxSession, (WebsocketInbound)in, (WebsocketOutbound)out))))).onErrorResume((Function1 & Serializable)throwable -> this.handleHttpHandshakeError((Throwable)throwable, httpServerResponse)).subscribeOn(Schedulers.elastic()).asJava().then();
    }

    private Mono<Void> handleWebSocketConnection(MailboxSession session, WebsocketInbound in, WebsocketOutbound out) {
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        ClientContext context = new ClientContext((Sinks.Many<OutboundMessage>)sink, new AtomicReference<Registration>(), session);
        SFlux qual$1 = SFlux$.MODULE$.apply((Publisher)in.aggregateFrames().receiveFrames()).map((Function1 & Serializable)frame -> {
            byte[] bytes = new byte[frame.content().readableBytes()];
            frame.content().readBytes(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)message -> this.handleClientMessages(context, (String)message);
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SFlux responseFlux = qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean()).doOnCancel((Function0)(JFunction0.mcV.sp & Serializable)() -> context.clean());
        return out.sendString((Publisher)SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)responseFlux, (List)new .colon.colon((Object)sink.asFlux(), (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).map((Function1 & Serializable)outboundMessage -> $this.pushSerializer.serialize((OutboundMessage)outboundMessage)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json))).then();
    }

    private SMono<OutboundMessage> handleClientMessages(ClientContext clientContext, String message) {
        return (SMono)this.pushSerializer.deserializeWebSocketInboundMessage(message).fold((Function1 & Serializable)invalid -> {
            WebSocketError error = this.asError((Option<RequestId>)None$.MODULE$, new IllegalArgumentException(invalid.toString()));
            return SMono$.MODULE$.just((Object)error);
        }, (Function1 & Serializable)x0$1 -> {
            WebSocketInboundMessage webSocketInboundMessage = x0$1;
            if (webSocketInboundMessage instanceof WebSocketRequest) {
                WebSocketRequest webSocketRequest = (WebSocketRequest)webSocketInboundMessage;
                return $this.jmapApi.process(webSocketRequest.requestObject(), clientContext.session()).map((Function1 & Serializable)x$1 -> new WebSocketResponse(webSocketRequest.id(), (ResponseObject)x$1)).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)this.asError(webSocketRequest.id(), (Throwable)e))).subscribeOn(Schedulers.elastic());
            }
            if (webSocketInboundMessage instanceof WebSocketPushEnable) {
                WebSocketPushEnable webSocketPushEnable = (WebSocketPushEnable)webSocketInboundMessage;
                return SMono$.MODULE$.apply($this.eventBus.register((EventListener.ReactiveEventListener)new StateChangeListener((Set<TypeName>)((Set)webSocketPushEnable.dataTypes().getOrElse((Function0 & Serializable)() -> $this.typeStateFactory.all().toSet())), clientContext.outbound()), (RegistrationKey)AccountIdRegistrationKey$.MODULE$.of(clientContext.session().getUser()))).doOnNext((Function1 & Serializable)newRegistration -> {
                    clientContext.withRegistration(newRegistration);
                    return BoxedUnit.UNIT;
                }).then(this.sendPushStateIfRequested(webSocketPushEnable, clientContext));
            }
            if (WebSocketPushDisable$.MODULE$.equals(webSocketInboundMessage)) {
                return SMono$.MODULE$.fromCallable(() -> {
                    clientContext.clean();
                    return BoxedUnit.UNIT;
                }).then(SMono$.MODULE$.empty());
            }
            throw new MatchError((Object)webSocketInboundMessage);
        });
    }

    private SMono<OutboundMessage> sendPushStateIfRequested(WebSocketPushEnable pushEnable, ClientContext clientContext) {
        return (SMono)pushEnable.pushState().map((Function1 & Serializable)x$2 -> this.sendPushState(clientContext)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
    }

    private SMono<OutboundMessage> sendPushState(ClientContext clientContext) {
        Username username = clientContext.session().getUser();
        org.apache.james.jmap.core.AccountId accountId = (org.apache.james.jmap.core.AccountId)AccountId$.MODULE$.from(username).fold((Function1 & Serializable)failure -> {
            throw new IllegalArgumentException((Throwable)failure);
        }, (Function1 & Serializable)success -> success);
        return SMono$.MODULE$.apply((Publisher)this.mailboxChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).flatMap(mailboxState -> $this.emailChangeRepository.getLatestStateWithDelegation(AccountId.fromUsername((Username)username)).map(emailState -> new StateChange((Map<org.apache.james.jmap.core.AccountId, TypeState>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)accountId), (Object)new TypeState((Map<TypeName, org.apache.james.jmap.api.model.State>)((Map)MailboxTypeName$.MODULE$.asMap((Option<org.apache.james.jmap.api.model.State>)new Some((Object)UuidState$.MODULE$.fromJava((State)mailboxState))).$plus$plus(EmailTypeName$.MODULE$.asMap((Option<org.apache.james.jmap.api.model.State>)new Some((Object)UuidState$.MODULE$.fromJava((State)emailState)))))))}))), (Option<PushState>)new Some((Object)PushState$.MODULE$.from(new UuidState(mailboxState.getValue()), new UuidState(emailState.getValue())))))));
    }

    private SMono<Void> handleHttpHandshakeError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private WebSocketError asError(Option<RequestId> requestId, Throwable throwable) {
        return new WebSocketError(requestId, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").sendString((Publisher)SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()), StandardCharsets.UTF_8).then());
    }

    @Inject
    public WebSocketRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, @Named(value="JMAP") EventBus eventBus, JMAPApi jmapApi, MailboxChangeRepository mailboxChangeRepository, EmailChangeRepository emailChangeRepository, PushSerializer pushSerializer, TypeStateFactory typeStateFactory) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.eventBus = eventBus;
        this.jmapApi = jmapApi;
        this.mailboxChangeRepository = mailboxChangeRepository;
        this.emailChangeRepository = emailChangeRepository;
        this.pushSerializer = pushSerializer;
        this.typeStateFactory = typeStateFactory;
    }
}

