/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.config.TinkFips;
import com.google.crypto.tink.subtle.EngineWrapper;
import com.google.crypto.tink.subtle.SubtleUtil;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;

public final class EngineFactory<T_WRAPPER extends EngineWrapper<T_ENGINE>, T_ENGINE> {
    private static final Logger logger = Logger.getLogger(EngineFactory.class.getName());
    private static final List<Provider> policy;
    private static final boolean LET_FALLBACK;
    public static final EngineFactory<EngineWrapper.TCipher, Cipher> CIPHER;
    public static final EngineFactory<EngineWrapper.TMac, Mac> MAC;
    public static final EngineFactory<EngineWrapper.TSignature, Signature> SIGNATURE;
    public static final EngineFactory<EngineWrapper.TMessageDigest, MessageDigest> MESSAGE_DIGEST;
    public static final EngineFactory<EngineWrapper.TKeyAgreement, KeyAgreement> KEY_AGREEMENT;
    public static final EngineFactory<EngineWrapper.TKeyPairGenerator, KeyPairGenerator> KEY_PAIR_GENERATOR;
    public static final EngineFactory<EngineWrapper.TKeyFactory, KeyFactory> KEY_FACTORY;
    private final T_WRAPPER instanceBuilder;

    public static List<Provider> toProviderList(String ... providerNames) {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (String s : providerNames) {
            Provider p = Security.getProvider(s);
            if (p != null) {
                providers.add(p);
                continue;
            }
            logger.info(String.format("Provider %s not available", s));
        }
        return providers;
    }

    public EngineFactory(T_WRAPPER instanceBuilder) {
        this.instanceBuilder = instanceBuilder;
    }

    public T_ENGINE getInstance(String algorithm) throws GeneralSecurityException {
        Exception cause = null;
        for (Provider provider : policy) {
            try {
                return (T_ENGINE)this.instanceBuilder.getInstance(algorithm, provider);
            }
            catch (Exception e) {
                if (cause != null) continue;
                cause = e;
            }
        }
        if (LET_FALLBACK) {
            return (T_ENGINE)this.instanceBuilder.getInstance(algorithm, null);
        }
        throw new GeneralSecurityException("No good Provider found.", cause);
    }

    static {
        if (TinkFips.useOnlyFips()) {
            policy = EngineFactory.toProviderList("GmsCore_OpenSSL", "AndroidOpenSSL", "Conscrypt");
            LET_FALLBACK = false;
        } else if (SubtleUtil.isAndroid()) {
            policy = EngineFactory.toProviderList("GmsCore_OpenSSL", "AndroidOpenSSL");
            LET_FALLBACK = true;
        } else {
            policy = new ArrayList<Provider>();
            LET_FALLBACK = true;
        }
        CIPHER = new EngineFactory(new EngineWrapper.TCipher());
        MAC = new EngineFactory(new EngineWrapper.TMac());
        SIGNATURE = new EngineFactory(new EngineWrapper.TSignature());
        MESSAGE_DIGEST = new EngineFactory(new EngineWrapper.TMessageDigest());
        KEY_AGREEMENT = new EngineFactory(new EngineWrapper.TKeyAgreement());
        KEY_PAIR_GENERATOR = new EngineFactory(new EngineWrapper.TKeyPairGenerator());
        KEY_FACTORY = new EngineFactory(new EngineWrapper.TKeyFactory());
    }
}

