/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.util.Optional;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jwt.OidcJwtTokenVerifier;
import org.apache.james.protocols.api.OIDCSASLParser;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsersRepositoryAuthHook
implements AuthHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersRepositoryAuthHook.class);
    private final UsersRepository users;

    @Inject
    public UsersRepositoryAuthHook(UsersRepository users) {
        this.users = users;
    }

    public HookResult doAuth(SMTPSession session, Username username, String password) {
        try {
            if (this.users.test(username, password)) {
                session.setUsername(username);
                session.setRelayingAllowed(true);
                return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription("Authentication Successful").build();
            }
        }
        catch (UsersRepositoryException e) {
            LOGGER.info("Unable to access UsersRepository", (Throwable)e);
        }
        return HookResult.DECLINED;
    }

    public HookResult doSasl(SMTPSession session, OidcSASLConfiguration configuration, String initialResponse) {
        return OIDCSASLParser.parse((String)initialResponse).flatMap(value -> new OidcJwtTokenVerifier().verifyAndExtractClaim(value.getToken(), configuration.getJwksURL(), configuration.getClaim())).flatMap(this::extractUserFromClaim).map(username -> {
            try {
                this.users.assertValid(username);
                session.setUsername(username);
                session.setRelayingAllowed(true);
                return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription("Authentication successful.").build();
            }
            catch (UsersRepositoryException e) {
                LOGGER.warn("Invalid username", (Throwable)e);
                return HookResult.DECLINED;
            }
        }).orElse(HookResult.DECLINED);
    }

    private Optional<Username> extractUserFromClaim(String claimValue) {
        try {
            return Optional.of(Username.fromMailAddress((MailAddress)new MailAddress(claimValue)));
        }
        catch (AddressException e) {
            return Optional.empty();
        }
    }
}

