/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve.delivery;

import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.transport.mailets.jsieve.Poster;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;

public class SievePoster
implements Poster {
    private final String folder;
    private final UsersRepository usersRepository;

    public SievePoster(UsersRepository usersRepository, String folder) {
        this.usersRepository = usersRepository;
        this.folder = folder;
    }

    @Override
    public void post(String url, Mail mail) throws MessagingException {
        int endOfScheme = url.indexOf(58);
        if (endOfScheme < 0) {
            throw new MessagingException("Malformed URI");
        }
        String scheme = url.substring(0, endOfScheme);
        if (!scheme.equals("mailbox")) {
            throw new MessagingException("Unsupported protocol");
        }
        UserAndPath userAndPath = this.retrieveUserAndPath(url, endOfScheme);
        mail.setAttribute(Attribute.convertToAttribute((String)("DeliveryPath_" + userAndPath.user), (Object)userAndPath.path));
    }

    private UserAndPath retrieveUserAndPath(String url, int endOfScheme) throws MessagingException {
        int startOfUser = endOfScheme + 3;
        int endOfUser = url.indexOf(64, startOfUser);
        int startOfHost = endOfUser + 1;
        int endOfHost = url.indexOf(47, startOfHost);
        if (endOfUser < 0) {
            throw new MessagingException("Shared mailbox is not supported");
        }
        String host = url.substring(startOfHost, endOfHost);
        String user = this.retrieveUser(url, startOfUser, endOfUser, host).asString();
        String urlPath = this.parseUrlPath(url, endOfHost);
        return new UserAndPath(user, urlPath);
    }

    private String parseUrlPath(String url, int endOfHost) {
        int length = url.length();
        if (endOfHost + 1 == length) {
            return this.folder;
        }
        return url.substring(endOfHost, length);
    }

    private Username retrieveUser(String url, int startOfUser, int endOfUser, String host) throws MessagingException {
        String user = url.substring(startOfUser, endOfUser).toLowerCase(Locale.US);
        try {
            return this.usersRepository.getUsername(new MailAddress(user, host));
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException("Unable to accessUsersRepository", (Exception)((Object)e));
        }
    }

    private static class UserAndPath {
        private final String user;
        private final String path;

        public UserAndPath(String user, String path) {
            this.user = user;
            this.path = path;
        }
    }
}

