/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public class WhenClause
extends Expression {
    private final Expression operand;
    private final Expression result;

    public WhenClause(Expression operand, Expression result) {
        super(null);
        this.operand = Objects.requireNonNull(operand, "operand is null");
        this.result = Objects.requireNonNull(result, "result is null");
    }

    public WhenClause(NodeLocation location, Expression operand, Expression result) {
        super(Objects.requireNonNull(location, "location is null"));
        this.operand = Objects.requireNonNull(operand, "operand is null");
        this.result = Objects.requireNonNull(result, "result is null");
    }

    public WhenClause(ByteBuffer byteBuffer) {
        super(null);
        this.operand = Expression.deserialize(byteBuffer);
        this.result = Expression.deserialize(byteBuffer);
    }

    public Expression getOperand() {
        return this.operand;
    }

    public Expression getResult() {
        return this.result;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWhenClause(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.operand, (Object)this.result);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhenClause that = (WhenClause)o;
        return Objects.equals(this.operand, that.operand) && Objects.equals(this.result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operand, this.result);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return WhenClause.sameClass(this, other);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.WHEN_CLAUSE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.operand, byteBuffer);
        Expression.serialize(this.result, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.operand, stream);
        Expression.serialize(this.result, stream);
    }
}

