/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.GroupReference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Plans;

public class Memo {
    private static final int ROOT_GROUP_REF = 0;
    private final QueryId idAllocator;
    private final int rootGroup;
    private final Map<Integer, Group> groups = new HashMap<Integer, Group>();
    private int nextGroupId = 1;

    public Memo(QueryId idAllocator, PlanNode plan) {
        this.idAllocator = idAllocator;
        this.rootGroup = this.insertRecursive(plan);
        this.groups.get(this.rootGroup).incomingReferences.add((Object)0);
    }

    public int getRootGroup() {
        return this.rootGroup;
    }

    private Group getGroup(int group) {
        Preconditions.checkArgument((boolean)this.groups.containsKey(group), (String)"Invalid group: %s", (int)group);
        return this.groups.get(group);
    }

    public PlanNode getNode(int group) {
        return this.getGroup(group).membership;
    }

    public PlanNode resolve(GroupReference groupReference) {
        return this.getNode(groupReference.getGroupId());
    }

    public PlanNode extract() {
        return this.extract(this.getNode(this.rootGroup));
    }

    private PlanNode extract(PlanNode node) {
        return Plans.resolveGroupReferences(node, Lookup.from(planNode -> Stream.of(this.resolve((GroupReference)planNode))));
    }

    public PlanNode replace(int groupId, PlanNode node, String reason) {
        Group group = this.getGroup(groupId);
        PlanNode old = group.membership;
        Preconditions.checkArgument((boolean)new HashSet<Symbol>(old.getOutputSymbols()).equals(new HashSet<Symbol>(node.getOutputSymbols())), (String)"%s: transformed expression doesn't produce same outputs: %s vs %s", (Object)reason, old.getOutputSymbols(), node.getOutputSymbols());
        node = node instanceof GroupReference ? this.getNode(((GroupReference)node).getGroupId()) : this.insertChildrenAndRewrite(node);
        this.incrementReferenceCounts(node, groupId);
        group.membership = node;
        this.decrementReferenceCounts(old, groupId);
        this.evictStatisticsAndCost(group);
        return node;
    }

    private void evictStatisticsAndCost(Group group) {
        Iterator iterator = group.incomingReferences.elementSet().iterator();
        while (iterator.hasNext()) {
            int parentGroup = (Integer)iterator.next();
            if (parentGroup == 0) continue;
            this.evictStatisticsAndCost(this.getGroup(parentGroup));
        }
    }

    private void incrementReferenceCounts(PlanNode fromNode, int fromGroup) {
        Set<Integer> references = this.getAllReferences(fromNode);
        for (int group : references) {
            this.groups.get(group).incomingReferences.add((Object)fromGroup);
        }
    }

    private void decrementReferenceCounts(PlanNode fromNode, int fromGroup) {
        Set<Integer> references = this.getAllReferences(fromNode);
        for (int group : references) {
            Group childGroup = this.groups.get(group);
            Preconditions.checkState((boolean)childGroup.incomingReferences.remove((Object)fromGroup), (Object)"Reference to remove not found");
            if (!childGroup.incomingReferences.isEmpty()) continue;
            this.deleteGroup(group);
        }
    }

    private Set<Integer> getAllReferences(PlanNode node) {
        return node.getChildren().stream().map(GroupReference.class::cast).map(GroupReference::getGroupId).collect(Collectors.toSet());
    }

    private void deleteGroup(int group) {
        Preconditions.checkArgument((boolean)this.getGroup(group).incomingReferences.isEmpty(), (Object)"Cannot delete group that has incoming references");
        PlanNode deletedNode = this.groups.remove(group).membership;
        this.decrementReferenceCounts(deletedNode, group);
    }

    private PlanNode insertChildrenAndRewrite(PlanNode node) {
        return node.replaceChildren(node.getChildren().stream().map(child -> new GroupReference(this.idAllocator.genPlanNodeId(), this.insertRecursive((PlanNode)child), child.getOutputSymbols())).collect(Collectors.toList()));
    }

    private int insertRecursive(PlanNode node) {
        if (node instanceof GroupReference) {
            return ((GroupReference)node).getGroupId();
        }
        int group = this.nextGroupId();
        PlanNode rewritten = this.insertChildrenAndRewrite(node);
        this.groups.put(group, Group.withMember(rewritten));
        this.incrementReferenceCounts(rewritten, group);
        return group;
    }

    private int nextGroupId() {
        return this.nextGroupId++;
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    private static final class Group {
        private PlanNode membership;
        private final Multiset<Integer> incomingReferences = HashMultiset.create();

        static Group withMember(PlanNode member) {
            return new Group(member);
        }

        private Group(PlanNode member) {
            this.membership = Objects.requireNonNull(member, "member is null");
        }
    }
}

