/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;

public class Analyzer {
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;

    public Analyzer(MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    public Analysis analyze(Statement statement) {
        long startTime = System.nanoTime();
        Analysis analysis = (Analysis)new AnalyzeVisitor(this.partitionFetcher, this.schemaFetcher).process(statement, this.context);
        if (this.context.getSession() != null) {
            analysis.setDatabaseName(this.context.getDatabaseName().orElse(null));
        }
        if (statement.isQuery()) {
            long analyzeCost = System.nanoTime() - startTime - this.context.getFetchSchemaCost() - this.context.getFetchPartitionCost();
            QueryPlanCostMetricSet.getInstance().recordTreePlanCost("analyzer", analyzeCost);
            this.context.setAnalyzeCost(analyzeCost);
        }
        return analysis;
    }

    public static Analysis analyze(Statement statement, MPPQueryContext context) {
        return new Analyzer(context, ClusterPartitionFetcher.getInstance(), ClusterSchemaFetcher.getInstance()).analyze(statement);
    }
}

