/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.ObjectBigArray;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class BinaryBigArray {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(BinaryBigArray.class);
    private final ObjectBigArray<Binary> array = new ObjectBigArray();
    private long sizeOfBinarys;

    public long sizeOf() {
        return INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfBinarys;
    }

    public Binary get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Binary value) {
        this.updateRetainedSize(index, value);
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    private void updateRetainedSize(long index, Binary value) {
        Binary currentValue = this.array.get(index);
        if (currentValue != null) {
            this.sizeOfBinarys -= RamUsageEstimator.sizeOfObject((Object)currentValue);
        }
        if (value != null) {
            this.sizeOfBinarys += RamUsageEstimator.sizeOfObject((Object)value);
        }
    }

    public void reset() {
        this.array.reset();
    }
}

