/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.FlatHashStrategy;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.VariableWidthData;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class FlatHash {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FlatHash.class);
    private static final double DEFAULT_LOAD_FACTOR = 0.9375;
    private static final int RECORDS_PER_GROUP_SHIFT = 10;
    private static final int RECORDS_PER_GROUP = 1024;
    private static final int RECORDS_PER_GROUP_MASK = 1023;
    private static final int VECTOR_LENGTH = 8;
    private final FlatHashStrategy flatHashStrategy;
    private final boolean hasPrecomputedHash;
    private final int recordSize;
    private final int recordGroupIdOffset;
    private final int recordHashOffset;
    private final int recordValueOffset;
    private int capacity;
    private int mask;
    private byte[] control;
    private byte[][] recordGroups;
    private final VariableWidthData variableWidthData;
    private int[] groupRecordIndex;
    private final UpdateMemory checkMemoryReservation;
    private long fixedSizeEstimate;
    private long rehashMemoryReservation;
    private int nextGroupId;
    private int maxFill;

    private static int computeCapacity(int maxSize, double loadFactor) {
        int capacity = (int)((double)maxSize / loadFactor);
        return Math.max(Math.toIntExact(1L << 64 - Long.numberOfLeadingZeros(capacity - 1)), 16);
    }

    public FlatHash(FlatHashStrategy flatHashStrategy, boolean hasPrecomputedHash, int expectedSize, UpdateMemory checkMemoryReservation) {
        this.flatHashStrategy = flatHashStrategy;
        this.hasPrecomputedHash = hasPrecomputedHash;
        this.checkMemoryReservation = checkMemoryReservation;
        this.capacity = Math.max(8, FlatHash.computeCapacity(expectedSize, 0.9375));
        this.maxFill = FlatHash.calculateMaxFill(this.capacity);
        this.mask = this.capacity - 1;
        this.control = new byte[this.capacity + 8];
        this.groupRecordIndex = new int[this.maxFill];
        boolean variableWidth = flatHashStrategy.isAnyVariableWidth();
        this.variableWidthData = variableWidth ? new VariableWidthData() : null;
        this.recordGroupIdOffset = variableWidth ? 12 : 0;
        this.recordHashOffset = this.recordGroupIdOffset + 4;
        this.recordValueOffset = this.recordHashOffset + (hasPrecomputedHash ? 8 : 0);
        this.recordSize = this.recordValueOffset + flatHashStrategy.getTotalFlatFixedLength();
        this.recordGroups = FlatHash.createRecordGroups(this.capacity, this.recordSize);
        this.fixedSizeEstimate = FlatHash.computeFixedSizeEstimate(this.capacity, this.recordSize);
    }

    public long getEstimatedSize() {
        return FlatHash.sumExact(this.fixedSizeEstimate, this.variableWidthData == null ? 0L : this.variableWidthData.getRetainedSizeBytes(), this.rehashMemoryReservation);
    }

    public int size() {
        return this.nextGroupId;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public static long bytesToLong(byte[] bytes, int index) {
        if (bytes.length - 8 < 4) {
            throw new IllegalArgumentException("Invalid input: bytes.length - offset < 8");
        }
        long num = 0L;
        for (int ix = index + 7; ix >= index; --ix) {
            num <<= 8;
            num |= (long)(bytes[ix] & 0xFF);
        }
        return num;
    }

    public static int bytesToInt(byte[] bytes, int index) {
        if (bytes.length - index < 4) {
            throw new IllegalArgumentException("Invalid input: bytes.length - offset < 4");
        }
        int num = 0;
        for (int ix = index + 3; ix >= index; --ix) {
            num <<= 8;
            num |= bytes[ix] & 0xFF;
        }
        return num;
    }

    public static void intToBytes(byte[] desc, int offset, int i) {
        if (desc.length - offset < 4) {
            throw new IllegalArgumentException("Invalid input: desc.length - offset < 4");
        }
        desc[3 + offset] = (byte)(i >> 24 & 0xFF);
        desc[2 + offset] = (byte)(i >> 16 & 0xFF);
        desc[1 + offset] = (byte)(i >> 8 & 0xFF);
        desc[offset] = (byte)(i & 0xFF);
    }

    private static void longToBytes(byte[] desc, int offset, long num) {
        if (desc.length - offset < 8) {
            throw new IllegalArgumentException("Invalid input: desc.length - offset < 4");
        }
        for (int ix = 0; ix < 8; ++ix) {
            int i = ix * 8;
            desc[ix + offset] = (byte)(num >> i & 0xFFL);
        }
    }

    public long hashPosition(int groupId) {
        Preconditions.checkArgument((groupId < this.nextGroupId ? 1 : 0) != 0, (Object)"groupId out of range");
        int index = this.groupRecordIndex[groupId];
        byte[] records = this.getRecords(index);
        if (this.hasPrecomputedHash) {
            return FlatHash.bytesToLong(records, this.getRecordOffset(index) + this.recordHashOffset);
        }
        return this.valueHashCode(records, index);
    }

    public void appendTo(int groupId, ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((groupId < this.nextGroupId ? 1 : 0) != 0, (Object)"groupId out of range");
        int index = this.groupRecordIndex[groupId];
        byte[] records = this.getRecords(index);
        int recordOffset = this.getRecordOffset(index);
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
        }
        this.flatHashStrategy.readFlat(records, recordOffset + this.recordValueOffset, variableWidthChunk, columnBuilders);
        if (this.hasPrecomputedHash) {
            columnBuilders[columnBuilders.length - 1].writeLong(FlatHash.bytesToLong(records, recordOffset + this.recordHashOffset));
        }
    }

    public boolean contains(Column[] columns, int position) {
        return this.contains(columns, position, this.flatHashStrategy.hash(columns, position));
    }

    public boolean contains(Column[] columns, int position, long hash) {
        return this.getIndex(columns, position, hash) >= 0;
    }

    public void computeHashes(Column[] columns, long[] hashes, int offset, int length) {
        if (this.hasPrecomputedHash) {
            Column hashColumn = columns[columns.length - 1];
            for (int i = 0; i < length; ++i) {
                hashes[i] = hashColumn.getLong(offset + i);
            }
        } else {
            this.flatHashStrategy.hashBatched(columns, hashes, offset, length);
        }
    }

    public int putIfAbsent(Column[] columns, int position, long hash) {
        int index = this.getIndex(columns, position, hash);
        if (index >= 0) {
            return FlatHash.bytesToInt(this.getRecords(index), this.getRecordOffset(index) + this.recordGroupIdOffset);
        }
        index = -index - 1;
        int groupId = this.addNewGroup(index, columns, position, hash);
        if (this.nextGroupId >= this.maxFill) {
            this.rehash(0);
        }
        return groupId;
    }

    public int putIfAbsent(Column[] columns, int position) {
        long hash = this.flatHashStrategy.hash(columns, position);
        return this.putIfAbsent(columns, position, hash);
    }

    private int getIndex(Column[] columns, int position, long hash) {
        byte hashPrefix = (byte)(hash & 0x7FL | 0x80L);
        int bucket = this.bucket((int)(hash >> 7));
        int step = 1;
        long repeated = FlatHash.repeat(hashPrefix);
        long controlVector;
        int matchIndex;
        while ((matchIndex = this.matchInVector(columns, position, hash, bucket, repeated, controlVector = FlatHash.bytesToLong(this.control, bucket))) < 0) {
            int emptyIndex = this.findEmptyInVector(controlVector, bucket);
            if (emptyIndex >= 0) {
                return -emptyIndex - 1;
            }
            bucket = this.bucket(bucket + step);
            step += 8;
        }
        return matchIndex;
    }

    private int matchInVector(Column[] columns, int position, long hash, int vectorStartBucket, long repeated, long controlVector) {
        for (long controlMatches = FlatHash.match(controlVector, repeated); controlMatches != 0L; controlMatches &= controlMatches - 1L) {
            int index = this.bucket(vectorStartBucket + (Long.numberOfTrailingZeros(controlMatches) >>> 3));
            if (!this.valueNotDistinctFrom(index, columns, position, hash)) continue;
            return index;
        }
        return -1;
    }

    private int findEmptyInVector(long vector, int vectorStartBucket) {
        long controlMatches = FlatHash.match(vector, 0L);
        if (controlMatches == 0L) {
            return -1;
        }
        int slot = Long.numberOfTrailingZeros(controlMatches) >>> 3;
        return this.bucket(vectorStartBucket + slot);
    }

    private int addNewGroup(int index, Column[] columns, int position, long hash) {
        this.setControl(index, (byte)(hash & 0x7FL | 0x80L));
        byte[] records = this.getRecords(index);
        int recordOffset = this.getRecordOffset(index);
        int groupId = this.nextGroupId++;
        FlatHash.intToBytes(records, recordOffset + this.recordGroupIdOffset, groupId);
        this.groupRecordIndex[groupId] = index;
        if (this.hasPrecomputedHash) {
            FlatHash.longToBytes(records, recordOffset + this.recordHashOffset, hash);
        }
        byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        int variableWidthChunkOffset = 0;
        if (this.variableWidthData != null) {
            int variableWidthSize = this.flatHashStrategy.getTotalVariableWidth(columns, position);
            variableWidthChunk = this.variableWidthData.allocate(records, recordOffset, variableWidthSize);
            variableWidthChunkOffset = VariableWidthData.getChunkOffset(records, recordOffset);
        }
        this.flatHashStrategy.writeFlat(columns, position, records, recordOffset + this.recordValueOffset, variableWidthChunk, variableWidthChunkOffset);
        return groupId;
    }

    private void setControl(int index, byte hashPrefix) {
        this.control[index] = hashPrefix;
        if (index < 8) {
            this.control[index + this.capacity] = hashPrefix;
        }
    }

    public boolean ensureAvailableCapacity(int batchSize) {
        long requiredMaxFill = this.nextGroupId + batchSize;
        if (requiredMaxFill >= (long)this.maxFill) {
            long minimumRequiredCapacity = (requiredMaxFill + 1L) * 16L / 15L;
            return this.tryRehash(Math.toIntExact(minimumRequiredCapacity));
        }
        return true;
    }

    private boolean tryRehash(int minimumRequiredCapacity) {
        int newCapacity = this.computeNewCapacity(minimumRequiredCapacity);
        this.fixedSizeEstimate = FlatHash.computeFixedSizeEstimate(newCapacity, this.recordSize);
        this.rehashMemoryReservation = FlatHash.sumExact(RamUsageEstimator.sizeOf((byte[])this.control), RamUsageEstimator.sizeOf((byte[])this.recordGroups[0]));
        Verify.verify((this.rehashMemoryReservation >= 0L ? 1 : 0) != 0, (String)"rehashMemoryReservation is negative", (Object[])new Object[0]);
        if (!this.checkMemoryReservation.update()) {
            return false;
        }
        this.rehash(minimumRequiredCapacity);
        return true;
    }

    private void rehash(int minimumRequiredCapacity) {
        int oldCapacity = this.capacity;
        byte[] oldControl = this.control;
        byte[][] oldRecordGroups = this.recordGroups;
        this.capacity = this.computeNewCapacity(minimumRequiredCapacity);
        this.maxFill = FlatHash.calculateMaxFill(this.capacity);
        this.mask = this.capacity - 1;
        this.control = new byte[this.capacity + 8];
        this.recordGroups = this.capacity <= 1024 ? (Object)new byte[][]{new byte[FlatHash.multiplyExact(this.capacity, this.recordSize)]} : (byte[][])new byte[this.capacity + 1 >> 10][];
        this.groupRecordIndex = new int[this.maxFill];
        for (int oldRecordGroupIndex = 0; oldRecordGroupIndex < oldRecordGroups.length; ++oldRecordGroupIndex) {
            byte[] oldRecords = oldRecordGroups[oldRecordGroupIndex];
            oldRecordGroups[oldRecordGroupIndex] = null;
            block1: for (int indexInRecordGroup = 0; indexInRecordGroup < Math.min(1024, oldCapacity); ++indexInRecordGroup) {
                int oldIndex = (oldRecordGroupIndex << 10) + indexInRecordGroup;
                if (oldControl[oldIndex] == 0) continue;
                long hash = this.hasPrecomputedHash ? FlatHash.bytesToLong(oldRecords, this.getRecordOffset(oldIndex) + this.recordHashOffset) : this.valueHashCode(oldRecords, oldIndex);
                byte hashPrefix = (byte)(hash & 0x7FL | 0x80L);
                int bucket = this.bucket((int)(hash >> 7));
                int step = 1;
                while (true) {
                    long controlVector;
                    int emptyIndex;
                    if ((emptyIndex = this.findEmptyInVector(controlVector = FlatHash.bytesToLong(this.control, bucket), bucket)) >= 0) {
                        this.setControl(emptyIndex, hashPrefix);
                        int newRecordGroupIndex = emptyIndex >> 10;
                        byte[] records = this.recordGroups[newRecordGroupIndex];
                        if (records == null) {
                            records = new byte[FlatHash.multiplyExact(1024, this.recordSize)];
                            this.recordGroups[newRecordGroupIndex] = records;
                        }
                        int recordOffset = this.getRecordOffset(emptyIndex);
                        int oldRecordOffset = this.getRecordOffset(oldIndex);
                        System.arraycopy(oldRecords, oldRecordOffset, records, recordOffset, this.recordSize);
                        int groupId = FlatHash.bytesToInt(records, recordOffset + this.recordGroupIdOffset);
                        this.groupRecordIndex[groupId] = emptyIndex;
                        continue block1;
                    }
                    bucket = this.bucket(bucket + step);
                    step += 8;
                }
            }
        }
        for (int i = 0; i < this.recordGroups.length; ++i) {
            if (this.recordGroups[i] != null) continue;
            this.recordGroups[i] = new byte[FlatHash.multiplyExact(1024, this.recordSize)];
        }
        this.rehashMemoryReservation = 0L;
        this.fixedSizeEstimate = FlatHash.computeFixedSizeEstimate(this.capacity, this.recordSize);
        this.checkMemoryReservation.update();
    }

    private int computeNewCapacity(int minimumRequiredCapacity) {
        Preconditions.checkArgument((minimumRequiredCapacity >= 0 ? 1 : 0) != 0, (Object)"minimumRequiredCapacity must be positive");
        long newCapacityLong = (long)this.capacity * 2L;
        while (newCapacityLong < (long)minimumRequiredCapacity) {
            newCapacityLong = FlatHash.multiplyExact(newCapacityLong, 2L);
        }
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new RuntimeException("Size of hash table cannot exceed 1 billion entries");
        }
        return Math.toIntExact(newCapacityLong);
    }

    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)r;
    }

    private int bucket(int hash) {
        return hash & this.mask;
    }

    private byte[] getRecords(int index) {
        return this.recordGroups[index >> 10];
    }

    private int getRecordOffset(int index) {
        return (index & 0x3FF) * this.recordSize;
    }

    private long valueHashCode(byte[] records, int index) {
        int recordOffset = this.getRecordOffset(index);
        try {
            byte[] variableWidthChunk = VariableWidthData.EMPTY_CHUNK;
            if (this.variableWidthData != null) {
                variableWidthChunk = this.variableWidthData.getChunk(records, recordOffset);
            }
            return this.flatHashStrategy.hash(records, recordOffset + this.recordValueOffset, variableWidthChunk);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private boolean valueNotDistinctFrom(int leftIndex, Column[] rightColumns, int rightPosition, long rightHash) {
        long leftHash;
        byte[] leftRecords = this.getRecords(leftIndex);
        int leftRecordOffset = this.getRecordOffset(leftIndex);
        if (this.hasPrecomputedHash && (leftHash = FlatHash.bytesToLong(leftRecords, leftRecordOffset + this.recordHashOffset)) != rightHash) {
            return false;
        }
        byte[] leftVariableWidthChunk = VariableWidthData.EMPTY_CHUNK;
        if (this.variableWidthData != null) {
            leftVariableWidthChunk = this.variableWidthData.getChunk(leftRecords, leftRecordOffset);
        }
        return this.flatHashStrategy.valueNotDistinctFrom(leftRecords, leftRecordOffset + this.recordValueOffset, leftVariableWidthChunk, rightColumns, rightPosition);
    }

    private static long repeat(byte value) {
        return (long)(value & 0xFF) * 0x101010101010101L;
    }

    private static long match(long vector, long repeatedValue) {
        long comparison = vector ^ repeatedValue;
        return comparison - 0x101010101010101L & (comparison ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
    }

    public int getPhysicalPosition(int groupId) {
        return this.groupRecordIndex[groupId];
    }

    private static int calculateMaxFill(int capacity) {
        return Math.toIntExact((long)capacity * 15L / 16L);
    }

    private static byte[][] createRecordGroups(int capacity, int recordSize) {
        if (capacity <= 1024) {
            return new byte[][]{new byte[FlatHash.multiplyExact(capacity, recordSize)]};
        }
        byte[][] groups = new byte[capacity + 1 >> 10][];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = new byte[FlatHash.multiplyExact(1024, recordSize)];
        }
        return groups;
    }

    private static long computeRecordGroupsSize(int capacity, int recordSize) {
        if (capacity <= 1024) {
            return RamUsageEstimator.sizeOfObjectArray((int)1) + RamUsageEstimator.sizeOfByteArray((int)FlatHash.multiplyExact(capacity, recordSize));
        }
        int groupCount = Math.addExact(capacity, 1) >> 10;
        return RamUsageEstimator.sizeOfObjectArray((int)groupCount) + FlatHash.multiplyExact((long)groupCount, RamUsageEstimator.sizeOfByteArray((int)FlatHash.multiplyExact(1024, recordSize)));
    }

    private static long computeFixedSizeEstimate(int capacity, int recordSize) {
        return FlatHash.sumExact(INSTANCE_SIZE, RamUsageEstimator.sizeOfByteArray((int)(capacity + 8)), FlatHash.computeRecordGroupsSize(capacity, recordSize), RamUsageEstimator.sizeOfIntArray((int)capacity));
    }

    public static long sumExact(long ... values) {
        long result = 0L;
        for (long value : values) {
            result = Math.addExact(result, value);
        }
        return result;
    }
}

