/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile.subscription;

import java.util.concurrent.ExecutorService;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.subscription.SubscriptionTableSessionBuilder;
import org.apache.iotdb.session.subscription.SubscriptionTreeSessionBuilder;
import org.apache.iotdb.tool.tsfile.subscription.CommonParam;
import org.apache.iotdb.tool.tsfile.subscription.SubscriptionTableTsFile;
import org.apache.iotdb.tool.tsfile.subscription.SubscriptionTreeTsFile;

public abstract class AbstractSubscriptionTsFile {
    protected static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    protected static CommonParam commonParam = CommonParam.getInstance();

    public static void setSubscriptionSession() throws IoTDBConnectionException {
        if ("table".equalsIgnoreCase(commonParam.getSqlDialect())) {
            CommonParam.setSubscriptionTsFile(new SubscriptionTableTsFile());
            CommonParam.setTableSubs(new SubscriptionTableSessionBuilder().host(commonParam.getSrcHost()).port(commonParam.getSrcPort()).username(commonParam.getSrcUserName()).password(commonParam.getSrcPassword()).thriftMaxFrameSize(0x4000000).build());
            commonParam.getTableSubs().open();
        } else {
            CommonParam.setSubscriptionTsFile(new SubscriptionTreeTsFile());
            CommonParam.setTreeSubs(new SubscriptionTreeSessionBuilder().host(commonParam.getSrcHost()).port(commonParam.getSrcPort()).username(commonParam.getSrcUserName()).password(commonParam.getSrcPassword()).thriftMaxFrameSize(0x4000000).build());
            commonParam.getTreeSubs().open();
        }
    }

    public abstract void createTopics(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public abstract void doClean() throws Exception;

    public abstract void createConsumers(String var1);

    public abstract void subscribe(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public abstract void consumerPoll(ExecutorService var1, String var2);
}

