/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.db.pipe.agent.task.execution;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskExecutor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;

import java.util.concurrent.atomic.AtomicInteger;

public class PipeConnectorSubtaskExecutor extends PipeSubtaskExecutor {
  private static final AtomicInteger id = new AtomicInteger(0);

  public PipeConnectorSubtaskExecutor() {
    super(
        PipeConfig.getInstance().getPipeSubtaskExecutorMaxThreadNum(),
        ThreadName.PIPE_CONNECTOR_EXECUTOR_POOL.getName() + "-" + id.get(),
        ThreadName.PIPE_SUBTASK_CALLBACK_EXECUTOR_POOL.getName() + "-" + id.getAndIncrement(),
        true);
  }

  public PipeConnectorSubtaskExecutor(final int corePoolSize, final String threadName) {
    super(corePoolSize, threadName, true);
  }
}
