/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.constant;

import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.IllegalCompactionPerformerException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.IUnseqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadPointCompactionPerformer;

public enum InnerUnseqCompactionPerformer {
    READ_POINT,
    FAST;


    public static InnerUnseqCompactionPerformer getInnerUnseqCompactionPerformer(String name) {
        if (READ_POINT.toString().equalsIgnoreCase(name)) {
            return READ_POINT;
        }
        if (FAST.toString().equalsIgnoreCase(name)) {
            return FAST;
        }
        throw new IllegalCompactionPerformerException("Illegal compaction performer for unseq inner compaction " + name);
    }

    public IUnseqCompactionPerformer createInstance() {
        switch (this) {
            case READ_POINT: {
                return new ReadPointCompactionPerformer();
            }
            case FAST: {
                return new FastCompactionPerformer(false);
            }
        }
        throw new IllegalCompactionPerformerException("Illegal compaction performer for unseq inner compaction " + (Object)((Object)this));
    }
}

