/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadDirScanner;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadScheduledExecutorService;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadTsFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLoadMetricsCollector
extends ActiveLoadScheduledExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadMetricsCollector.class);
    private final ActiveLoadTsFileLoader activeLoadTsFileLoader;
    private final ActiveLoadDirScanner activeLoadDirScanner;
    private long countPendingFileRemainingSkipRound = 0L;
    private long countFailedFileRemainingSkipRound = 0L;

    public ActiveLoadMetricsCollector(ActiveLoadTsFileLoader activeLoadTsFileLoader, ActiveLoadDirScanner activeLoadDirScanner) {
        super(ThreadName.ACTIVE_LOAD_METRICS_COLLECTOR);
        this.activeLoadTsFileLoader = activeLoadTsFileLoader;
        this.activeLoadDirScanner = activeLoadDirScanner;
        this.register(this::countAndReportPendingFile);
        this.register(this::countAndReportFailedFile);
        LOGGER.info("Active load metric collector periodical jobs registered");
    }

    private void countAndReportPendingFile() {
        if (this.countPendingFileRemainingSkipRound > 0L) {
            --this.countPendingFileRemainingSkipRound;
            return;
        }
        long currentPendingFileNumber = this.activeLoadDirScanner.countAndReportActiveListeningDirsFileNumber();
        if (currentPendingFileNumber < 100L) {
            this.countPendingFileRemainingSkipRound = 6L;
            return;
        }
        if (currentPendingFileNumber < 1000L) {
            this.countPendingFileRemainingSkipRound = 18L;
            return;
        }
        if (currentPendingFileNumber < 10000L) {
            this.countPendingFileRemainingSkipRound = 120L;
            return;
        }
        this.countPendingFileRemainingSkipRound = 180L;
    }

    private void countAndReportFailedFile() {
        if (this.countFailedFileRemainingSkipRound > 0L) {
            --this.countFailedFileRemainingSkipRound;
            return;
        }
        long currentFailedFileNumber = this.activeLoadTsFileLoader.countAndReportFailedFileNumber();
        if (currentFailedFileNumber < 100L) {
            this.countFailedFileRemainingSkipRound = 6L;
            return;
        }
        if (currentFailedFileNumber < 1000L) {
            this.countFailedFileRemainingSkipRound = 18L;
            return;
        }
        if (currentFailedFileNumber < 10000L) {
            this.countFailedFileRemainingSkipRound = 120L;
            return;
        }
        this.countFailedFileRemainingSkipRound = currentFailedFileNumber / 50L;
    }
}

