/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnEncoding;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.tsfile.read.common.block.column.ColumnEncoderFactory;
import org.apache.tsfile.read.common.block.column.TimeColumn;

public class TsBlockSerde {
    public TsBlock deserialize(ByteBuffer byteBuffer) {
        int valueColumnCount = byteBuffer.getInt();
        ArrayList<TSDataType> valueColumnDataTypes = new ArrayList<TSDataType>(valueColumnCount);
        for (int i = 0; i < valueColumnCount; ++i) {
            valueColumnDataTypes.add(TSDataType.deserializeFrom((ByteBuffer)byteBuffer));
        }
        int positionCount = byteBuffer.getInt();
        ArrayList<ColumnEncoding> columnEncodings = new ArrayList<ColumnEncoding>(valueColumnCount + 1);
        for (int i = 0; i < valueColumnCount + 1; ++i) {
            columnEncodings.add(ColumnEncoding.deserializeFrom((ByteBuffer)byteBuffer));
        }
        TimeColumn timeColumn = ColumnEncoderFactory.get((ColumnEncoding)columnEncodings.get(0)).readTimeColumn(byteBuffer, positionCount);
        Column[] valueColumns = new Column[valueColumnCount];
        for (int i = 0; i < valueColumnCount; ++i) {
            valueColumns[i] = ColumnEncoderFactory.get((ColumnEncoding)columnEncodings.get(1 + i)).readColumn(byteBuffer, (TSDataType)valueColumnDataTypes.get(i), positionCount);
        }
        return new TsBlock(positionCount, timeColumn, valueColumns);
    }

    public ByteBuffer serialize(TsBlock tsBlock) throws IOException {
        int i;
        if (tsBlock.getRetainedSizeInBytes() > Integer.MAX_VALUE) {
            throw new IllegalStateException("TsBlock should not be that large: " + tsBlock.getRetainedSizeInBytes());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)tsBlock.getRetainedSizeInBytes());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(tsBlock.getValueColumnCount());
        for (i = 0; i < tsBlock.getValueColumnCount(); ++i) {
            tsBlock.getColumn(i).getDataType().serializeTo(dataOutputStream);
        }
        dataOutputStream.writeInt(tsBlock.getPositionCount());
        tsBlock.getTimeColumn().getEncoding().serializeTo(dataOutputStream);
        for (i = 0; i < tsBlock.getValueColumnCount(); ++i) {
            tsBlock.getColumn(i).getEncoding().serializeTo(dataOutputStream);
        }
        ColumnEncoder columnEncoder = ColumnEncoderFactory.get(tsBlock.getTimeColumn().getEncoding());
        columnEncoder.writeColumn(dataOutputStream, tsBlock.getTimeColumn());
        for (int i2 = 0; i2 < tsBlock.getValueColumnCount(); ++i2) {
            columnEncoder = ColumnEncoderFactory.get(tsBlock.getColumn(i2).getEncoding());
            columnEncoder.writeColumn(dataOutputStream, tsBlock.getColumn(i2));
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }
}

