/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.raft.storage.GroupStoragesDestructionIntents;
import org.apache.ignite3.internal.raft.storage.impl.StorageDestructionIntent;
import org.apache.ignite3.internal.raft.storage.impl.StorageDestructionIntentSerializer;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.vault.VaultEntry;
import org.apache.ignite3.internal.vault.VaultManager;
import org.apache.ignite3.internal.versioned.VersionedSerialization;

public class VaultGroupStoragesDestructionIntents
implements GroupStoragesDestructionIntents {
    private static final byte[] GROUP_STORAGE_DESTRUCTION_PREFIX = "destroy.group.storages.".getBytes(StandardCharsets.UTF_8);
    private static final ByteOrder BYTE_UTILS_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private final VaultManager vault;

    public VaultGroupStoragesDestructionIntents(VaultManager vault) {
        this.vault = vault;
    }

    @Override
    public void saveStorageDestructionIntent(ReplicationGroupId groupId, StorageDestructionIntent storageDestructionIntent) {
        this.vault.put(VaultGroupStoragesDestructionIntents.buildKey(storageDestructionIntent.nodeId()), VersionedSerialization.toBytes(storageDestructionIntent, StorageDestructionIntentSerializer.INSTANCE));
    }

    @Override
    public void removeStorageDestructionIntent(String nodeId) {
        this.vault.remove(VaultGroupStoragesDestructionIntents.buildKey(nodeId));
    }

    private static ByteArray buildKey(String nodeId) {
        byte[] nodeIdBytes = nodeId.getBytes(StandardCharsets.UTF_8);
        byte[] key = ByteBuffer.allocate(GROUP_STORAGE_DESTRUCTION_PREFIX.length + nodeIdBytes.length).order(BYTE_UTILS_BYTE_ORDER).put(GROUP_STORAGE_DESTRUCTION_PREFIX).put(nodeIdBytes).array();
        return new ByteArray(key);
    }

    @Override
    public Collection<StorageDestructionIntent> readStorageDestructionIntents() {
        try (Cursor<VaultEntry> cursor = this.vault.prefix(new ByteArray(GROUP_STORAGE_DESTRUCTION_PREFIX));){
            ArrayList<StorageDestructionIntent> result = new ArrayList<StorageDestructionIntent>();
            while (cursor.hasNext()) {
                VaultEntry next = (VaultEntry)cursor.next();
                StorageDestructionIntent intent = VersionedSerialization.fromBytes(next.value(), StorageDestructionIntentSerializer.INSTANCE);
                result.add(intent);
            }
            ArrayList<StorageDestructionIntent> arrayList = result;
            return arrayList;
        }
    }
}

