/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ignite.internal.processors.query.h2.sys.SqlSystemIndex;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemView;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableBase;
import org.h2.table.TableType;

public class SystemViewH2Adapter
extends TableBase {
    protected final SqlSystemIndex scanIdx;
    protected final SqlSystemView view;
    protected final ArrayList<Index> indexes;

    public SystemViewH2Adapter(CreateTableData data, SqlSystemView view) {
        super(data);
        assert (view != null);
        this.view = view;
        this.setColumns(view.getColumns());
        this.scanIdx = new SqlSystemIndex(this, new Column[0]);
        this.indexes = new ArrayList();
        this.indexes.add((Index)this.scanIdx);
        if (view.getIndexes() != null) {
            for (String idxStr : view.getIndexes()) {
                String[] indexedCols = idxStr.split(",");
                Column[] cols = new Column[indexedCols.length];
                for (int i = 0; i < indexedCols.length; ++i) {
                    cols[i] = this.getColumn(indexedCols[i]);
                }
                SqlSystemIndex idx = new SqlSystemIndex(this, cols);
                this.indexes.add((Index)idx);
            }
        }
    }

    public Index addIndex(Session ses, String idxName, int idxId, IndexColumn[] cols, IndexType idxType, boolean create, String idxComment) {
        throw DbException.getUnsupportedException((String)"META");
    }

    public boolean lock(Session ses, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    public void unlock(Session ses) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"META");
    }

    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"META");
    }

    public void removeChildrenAndResources(Session ses) {
        throw DbException.getUnsupportedException((String)"META");
    }

    public void close(Session ses) {
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"META");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"META");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"META");
    }

    public long getRowCount(Session ses) {
        return this.view.getRowCount();
    }

    public boolean canGetRowCount() {
        return this.view.canGetRowCount();
    }

    public long getRowCountApproximation() {
        return this.view.getRowCountApproximation();
    }

    public boolean canDrop() {
        return false;
    }

    public TableType getTableType() {
        return TableType.VIEW;
    }

    public Index getScanIndex(Session ses) {
        return this.scanIdx;
    }

    public Index getUniqueIndex() {
        return null;
    }

    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public boolean isDeterministic() {
        return false;
    }

    public boolean canReference() {
        return false;
    }

    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        return this.view.getRows(ses, first, last);
    }
}

