/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.processors.query.calcite.hint.HintDefinition;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteJoinConverterRule;

public class NestedLoopJoinConverterRule
extends AbstractIgniteJoinConverterRule {
    public static final RelOptRule INSTANCE = new NestedLoopJoinConverterRule();

    public NestedLoopJoinConverterRule() {
        super("NestedLoopJoinConverter", HintDefinition.NL_JOIN);
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalJoin rel) {
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet outTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelTraitSet leftInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelTraitSet rightInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelNode left = NestedLoopJoinConverterRule.convert((RelNode)rel.getLeft(), (RelTraitSet)leftInTraits);
        RelNode right = NestedLoopJoinConverterRule.convert((RelNode)rel.getRight(), (RelTraitSet)rightInTraits);
        return new IgniteNestedLoopJoin(cluster, outTraits, left, right, rel.getCondition(), rel.getVariablesSet(), rel.getJoinType());
    }
}

