/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Ordering;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverter;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;

public class IgniteMdCollation
implements MetadataHandler<BuiltInMetadata.Collation> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.COLLATIONS.method, (MetadataHandler)new IgniteMdCollation());

    private IgniteMdCollation() {
    }

    public MetadataDef<BuiltInMetadata.Collation> getDef() {
        return BuiltInMetadata.Collation.DEF;
    }

    public ImmutableList<RelCollation> collations(RelNode rel, RelMetadataQuery mq) {
        return ImmutableList.of();
    }

    public ImmutableList<RelCollation> collations(IgniteRel rel, RelMetadataQuery mq) {
        RelCollation collation = rel.collation();
        if (collation == null || F.isEmpty((Collection)collation.getFieldCollations())) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)collation);
    }

    public ImmutableList<RelCollation> collations(Window rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.window(mq, rel.getInput(), (ImmutableList<Window.Group>)rel.groups));
    }

    public ImmutableList<RelCollation> collations(Match rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.match(mq, rel.getInput(), rel.getRowType(), rel.getPattern(), rel.isStrictStart(), rel.isStrictEnd(), (Map<String, RexNode>)rel.getPatternDefinitions(), (Map<String, RexNode>)rel.getMeasures(), rel.getAfter(), (Map<String, ? extends SortedSet<String>>)rel.getSubsets(), rel.isAllRows(), rel.getPartitionKeys(), rel.getOrderKeys(), rel.getInterval()));
    }

    public ImmutableList<RelCollation> collations(Filter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(TableModify rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(TableScan scan, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.table(scan.getTable()));
    }

    public ImmutableList<RelCollation> collations(Sort sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)RelMdCollation.sort((RelCollation)sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(SortExchange sort, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)RelMdCollation.sort((RelCollation)sort.getCollation()));
    }

    public ImmutableList<RelCollation> collations(Project project, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.project(mq, project.getInput(), project.getProjects()));
    }

    public ImmutableList<RelCollation> collations(Calc calc, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.calc(mq, calc.getInput(), calc.getProgram()));
    }

    public ImmutableList<RelCollation> collations(Values values, RelMetadataQuery mq) {
        return ImmutableList.copyOf(IgniteMdCollation.values(mq, values.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)values.getTuples()));
    }

    public ImmutableList<RelCollation> collations(JdbcToEnumerableConverter rel, RelMetadataQuery mq) {
        return mq.collations(rel.getInput());
    }

    public ImmutableList<RelCollation> collations(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.collations(rel.getCurrentRel());
    }

    public ImmutableList<RelCollation> collations(RelSubset rel, RelMetadataQuery mq) {
        return ImmutableList.copyOf((Collection)Objects.requireNonNull(rel.getTraitSet().getTraits((RelTraitDef)RelCollationTraitDef.INSTANCE)));
    }

    public static List<RelCollation> table(RelOptTable table) {
        return table.getCollationList();
    }

    public static List<RelCollation> calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        List projects = program.getProjectList().stream().map(arg_0 -> ((RexProgram)program).expandLocalRef(arg_0)).collect(Collectors.toList());
        return IgniteMdCollation.project(mq, input, projects);
    }

    public static List<RelCollation> project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        TreeSet<RelCollation> collations = new TreeSet<RelCollation>();
        ImmutableList inputCollations = mq.collations(input);
        if (inputCollations == null || inputCollations.isEmpty()) {
            return ImmutableList.of();
        }
        LinkedListMultimap targets = LinkedListMultimap.create();
        HashMap<Integer, SqlMonotonicity> targetsWithMonotonicity = new HashMap<Integer, SqlMonotonicity>();
        for (Object project : Ord.zip(projects)) {
            if (((Ord)project).e instanceof RexInputRef) {
                targets.put((Object)((RexInputRef)((Ord)project).e).getIndex(), (Object)((Ord)project).i);
                continue;
            }
            if (!(((Ord)project).e instanceof RexCall)) continue;
            RexCall call = (RexCall)((Ord)project).e;
            RexCallBinding binding = RexCallBinding.create((RelDataTypeFactory)Commons.typeFactory(input), (RexCall)call, (List)inputCollations);
            targetsWithMonotonicity.put(((Ord)project).i, call.getOperator().getMonotonicity((SqlOperatorBinding)binding));
        }
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        block4: for (RelCollation ic : inputCollations) {
            if (ic.getFieldCollations().isEmpty()) continue;
            fieldCollations.clear();
            for (RelFieldCollation ifc : ic.getFieldCollations()) {
                Collection integers = targets.get((Object)ifc.getFieldIndex());
                if (integers.isEmpty()) continue block4;
                fieldCollations.add(ifc.withFieldIndex(((Integer)integers.iterator().next()).intValue()));
            }
            assert (!fieldCollations.isEmpty());
            collations.add(RelCollations.of(fieldCollations));
        }
        ArrayList<RelFieldCollation> fieldCollationsForRexCalls = new ArrayList<RelFieldCollation>();
        block6: for (Map.Entry entry : targetsWithMonotonicity.entrySet()) {
            SqlMonotonicity val = (SqlMonotonicity)entry.getValue();
            switch (val) {
                case NOT_MONOTONIC: 
                case CONSTANT: {
                    continue block6;
                }
            }
            fieldCollationsForRexCalls.add(new RelFieldCollation(((Integer)entry.getKey()).intValue(), RelFieldCollation.Direction.of((SqlMonotonicity)val)));
        }
        if (!fieldCollationsForRexCalls.isEmpty()) {
            collations.add(RelCollations.of(fieldCollationsForRexCalls));
        }
        return ImmutableList.copyOf(collations);
    }

    public static List<RelCollation> window(RelMetadataQuery mq, RelNode input, ImmutableList<Window.Group> groups) {
        return mq.collations(input);
    }

    public static List<RelCollation> match(RelMetadataQuery mq, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        return mq.collations(input);
    }

    public static List<RelCollation> values(RelMetadataQuery mq, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        Util.discard((Object)mq);
        ArrayList<RelCollation> list = new ArrayList<RelCollation>();
        int n = rowType.getFieldCount();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        block0: for (int i = 0; i < n; ++i) {
            pairs.clear();
            for (int j = i; j < n; ++j) {
                RelFieldCollation fieldCollation = new RelFieldCollation(j);
                Ordering comparator = IgniteMdCollation.comparator(fieldCollation);
                Ordering ordering = pairs.isEmpty() ? comparator : ((Ordering)((Pair)Util.last(pairs)).right).compound(comparator);
                pairs.add(Pair.of((Object)fieldCollation, ordering));
                if (ordering.isOrdered(tuples)) continue;
                if (j == i) continue block0;
                pairs.remove(pairs.size() - 1);
            }
            if (pairs.isEmpty()) continue;
            list.add(RelCollations.of((List)Pair.left(pairs)));
        }
        return list;
    }

    private static Ordering<List<RexLiteral>> comparator(RelFieldCollation fieldCollation) {
        final int nullComparison = fieldCollation.nullDirection.nullComparison;
        final int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Ordering<List<RexLiteral>>(){

                    public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                        Comparable c1 = (Comparable)o1.get(x).getValueAs(Comparable.class);
                        Comparable c2 = (Comparable)o2.get(x).getValueAs(Comparable.class);
                        return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
                    }
                };
            }
        }
        return new Ordering<List<RexLiteral>>(){

            public int compare(List<RexLiteral> o1, List<RexLiteral> o2) {
                Comparable c1 = (Comparable)o1.get(x).getValueAs(Comparable.class);
                Comparable c2 = (Comparable)o2.get(x).getValueAs(Comparable.class);
                return RelFieldCollation.compare((Comparable)c2, (Comparable)c1, (int)(-nullComparison));
            }
        };
    }
}

