/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mxbean;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.management.JMException;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParameter;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

@MXBeanDescription(value="MBean that provides access to Kernal information.")
public interface IgniteMXBean {
    public static final String FULL_VER_DESC = "String presentation of the Ignite version.";
    public static final String COPYRIGHT_DESC = "Copyright statement for Ignite product.";
    public static final String START_TIMESTAMP_FORMATTED_DESC = "String presentation of the kernal start timestamp.";
    public static final String IS_REBALANCE_ENABLED_DESC = "Rebalance enabled flag.";
    public static final String UPTIME_FORMATTED_DESC = "String presentation of up-time for the kernal.";
    public static final String START_TIMESTAMP_DESC = "Start timestamp of the kernal.";
    public static final String UPTIME_DESC = "Up-time of the kernal.";
    public static final String LONG_JVM_PAUSES_CNT_DESC = "Long JVM pauses count.";
    public static final String LONG_JVM_PAUSES_TOTAL_DURATION_DESC = "Long JVM pauses total duration.";
    public static final String LONG_JVM_PAUSE_LAST_EVENTS_DESC = "Long JVM pause last events.";
    public static final String USER_ATTRS_FORMATTED_DESC = "Collection of formatted user-defined attributes added to this node.";
    public static final String GRID_LOG_FORMATTED_DESC = "Formatted instance of logger that is in grid.";
    public static final String EXECUTOR_SRVC_FORMATTED_DESC = "Formatted instance of fully configured thread pool that is used in grid.";
    public static final String IGNITE_HOME_DESC = "Ignite installation home folder.";
    public static final String MBEAN_SERVER_FORMATTED_DESC = "Formatted instance of MBean server instance.";
    public static final String LOC_NODE_ID_DESC = "Unique identifier for this node within grid.";
    public static final String IS_PEER_CLS_LOADING_ENABLED_DESC = "Whether or not peer class loading (a.k.a. P2P class loading) is enabled.";
    public static final String LIFECYCLE_BEANS_FORMATTED_DESC = "String representation of lifecycle beans.";
    public static final String ACTIVE_DESC = "Checks Ignite grid is active or is not active.";
    public static final String DISCOVERY_SPI_FORMATTED_DESC = "Formatted instance of configured discovery SPI implementation.";
    public static final String COMMUNICATION_SPI_FORMATTED_DESC = "Formatted instance of fully configured SPI communication implementation.";
    public static final String DEPLOYMENT_SPI_FORMATTED_DESC = "Formatted instance of fully configured deployment SPI implementation.";
    public static final String CHECKPOINT_SPI_FORMATTED_DESC = "Formatted instance of configured checkpoint SPI implementation.";
    public static final String COLLISION_SPI_FORMATTED_DESC = "Formatted instance of configured collision SPI implementations.";
    public static final String EVT_STORAGE_SPI_FORMATTED_DESC = "Formatted instance of fully configured event SPI implementation.";
    public static final String FAILOVER_SPI_FORMATTED_DESC = "Formatted instance of fully configured failover SPI implementations.";
    public static final String LOAD_BALANCING_SPI_FORMATTED_DESC = "Formatted instance of fully configured load balancing SPI implementations.";
    public static final String OS_INFO_DESC = "OS information.";
    public static final String JDK_INFO_DESC = "JDK information.";
    public static final String OS_USER_DESC = "OS user name.";
    public static final String VM_NAME_DESC = "VM name.";
    public static final String INSTANCE_NAME_DESC = "Optional kernal instance name.";
    public static final String CUR_COORDINATOR_FORMATTED_DESC = "Formatted properties of current coordinator.";
    public static final String IS_NODE_BASELINE_DESC = "Baseline node flag.";
    public static final String LAST_CLUSTER_STATE_CHANGE_TIME_DESC = "Unix time of last cluster state change operation.";
    public static final String CLUSTER_STATE_DESC = "Checks cluster state.";
    public static final String READ_ONLY_MODE_DESC = "Cluster read-only mode status.";
    public static final String READ_ONLY_MODE_DURATION_DESC = "Duration of read-only mode enabled on cluster.";

    @Deprecated
    @MXBeanDescription(value="String presentation of the Ignite version.")
    public String getFullVersion();

    @Deprecated
    @MXBeanDescription(value="Copyright statement for Ignite product.")
    public String getCopyright();

    @Deprecated
    @MXBeanDescription(value="Start timestamp of the kernal.")
    public String getStartTimestampFormatted();

    @Deprecated
    @MXBeanDescription(value="Rebalance enabled flag.")
    public boolean isRebalanceEnabled();

    @MXBeanParametersDescriptions(value={"Enable cache partitions rebalance on node.", "Disable cache partitions rebalance on node."})
    public void rebalanceEnabled(boolean var1);

    @Deprecated
    @MXBeanDescription(value="String presentation of up-time for the kernal.")
    public String getUpTimeFormatted();

    @Deprecated
    @MXBeanDescription(value="Start timestamp of the kernal.")
    public long getStartTimestamp();

    @Deprecated
    @MXBeanDescription(value="Up-time of the kernal.")
    public long getUpTime();

    @Deprecated
    @MXBeanDescription(value="Long JVM pauses count.")
    public long getLongJVMPausesCount();

    @Deprecated
    @MXBeanDescription(value="Long JVM pauses total duration.")
    public long getLongJVMPausesTotalDuration();

    @Deprecated
    @MXBeanDescription(value="Long JVM pause last events.")
    public Map<Long, Long> getLongJVMPauseLastEvents();

    @Deprecated
    @MXBeanDescription(value="Collection of formatted user-defined attributes added to this node.")
    public List<String> getUserAttributesFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of logger that is in grid.")
    public String getGridLoggerFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured thread pool that is used in grid.")
    public String getExecutorServiceFormatted();

    @Deprecated
    @MXBeanDescription(value="Ignite installation home folder.")
    public String getIgniteHome();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of MBean server instance.")
    public String getMBeanServerFormatted();

    @Deprecated
    @MXBeanDescription(value="Unique identifier for this node within grid.")
    public UUID getLocalNodeId();

    @Deprecated
    @MXBeanDescription(value="Whether or not peer class loading (a.k.a. P2P class loading) is enabled.")
    public boolean isPeerClassLoadingEnabled();

    @Deprecated
    @MXBeanDescription(value="String representation of lifecycle beans.")
    public List<String> getLifecycleBeansFormatted();

    @MXBeanDescription(value="This method allows manually remove the checkpoint with given key. Return true if specified checkpoint was indeed removed, false otherwise.")
    public boolean removeCheckpoint(@MXBeanParameter(name="key", description="Checkpoint key to remove.") String var1);

    @MXBeanDescription(value="Pings node with given node ID to see whether it is alive. Returns whether or not node is alive.")
    public boolean pingNode(@MXBeanParameter(name="nodeId", description="String presentation of node ID. See java.util.UUID class for details.") String var1);

    @Deprecated
    @MXBeanDescription(value="Execute activate or deactivate process.")
    @MXBeanParametersNames(value={"active"})
    public void active(boolean var1) throws JMException;

    @Deprecated
    @MXBeanDescription(value="Checks Ignite grid is active or is not active.")
    public boolean active();

    @MXBeanDescription(value="Makes the best attempt to undeploy a task from the whole grid.")
    public void undeployTaskFromGrid(@MXBeanParameter(name="taskName", description="Name of the task to undeploy.") String var1) throws JMException;

    @MXBeanDescription(value="A shortcut method that executes given task assuming single String argument and String return type. Returns Task return value (assumed of String type).")
    public String executeTask(@MXBeanParameter(name="taskName", description="Name of the task to execute.") String var1, @MXBeanParameter(name="arg", description="Single task execution argument (can be null).") String var2) throws JMException;

    @MXBeanDescription(value="Pings node with given host name to see if it is alive. Returns whether or not node is alive.")
    public boolean pingNodeByAddress(@MXBeanParameter(name="host", description="Host name or IP address of the node to ping.") String var1) throws JMException;

    @Deprecated
    @MXBeanDescription(value="Formatted instance of configured discovery SPI implementation.")
    public String getDiscoverySpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured SPI communication implementation.")
    public String getCommunicationSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured deployment SPI implementation.")
    public String getDeploymentSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of configured checkpoint SPI implementation.")
    public String getCheckpointSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of configured collision SPI implementations.")
    public String getCollisionSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured event SPI implementation.")
    public String getEventStorageSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured failover SPI implementations.")
    public String getFailoverSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="Formatted instance of fully configured load balancing SPI implementations.")
    public String getLoadBalancingSpiFormatted();

    @Deprecated
    @MXBeanDescription(value="OS information.")
    public String getOsInformation();

    @Deprecated
    @MXBeanDescription(value="JDK information.")
    public String getJdkInformation();

    @Deprecated
    @MXBeanDescription(value="OS user name.")
    public String getOsUser();

    @Deprecated
    @MXBeanDescription(value="VM name.")
    public String getVmName();

    @Deprecated
    @MXBeanDescription(value="Optional kernal instance name.")
    public String getInstanceName();

    @MXBeanDescription(value="Prints last suppressed errors.")
    public void printLastErrors();

    @MXBeanDescription(value="Dumps debug information for the current node.")
    public void dumpDebugInfo();

    @Deprecated
    @MXBeanDescription(value="Formatted properties of current coordinator.")
    public String getCurrentCoordinatorFormatted();

    @Deprecated
    @MXBeanDescription(value="Baseline node flag.")
    public boolean isNodeInBaseline();

    @MXBeanDescription(value="Runs IO latency test against all remote server nodes in cluster.")
    public void runIoTest(@MXBeanParameter(name="warmup", description="Warmup duration (millis).") long var1, @MXBeanParameter(name="duration", description="Test duration (millis).") long var3, @MXBeanParameter(name="threads", description="Threads count.") int var5, @MXBeanParameter(name="maxLatency", description="Maximum latency expected (nanos).") long var6, @MXBeanParameter(name="rangesCnt", description="Ranges count for histogram.") int var8, @MXBeanParameter(name="payLoadSize", description="Payload size (bytes).") int var9, @MXBeanParameter(name="procFromNioThread", description="Process requests in NIO-threads flag.") boolean var10);

    @MXBeanDescription(value="Clears local node map.")
    public void clearNodeLocalMap();

    @Deprecated
    @MXBeanDescription(value="Checks cluster state.")
    public String clusterState();

    @Deprecated
    @MXBeanDescription(value="Changes current cluster state.")
    public void clusterState(@MXBeanParameter(name="state", description="New cluster state.") String var1) throws JMException;

    @MXBeanDescription(value="Changes current cluster state.")
    public void clusterState(@MXBeanParameter(name="state", description="New cluster state.") String var1, @MXBeanParameter(name="forceDeactivation", description="If true, cluster deactivation will be forced.") boolean var2) throws JMException;

    @Deprecated
    @MXBeanDescription(value="Unix time of last cluster state change operation.")
    public long lastClusterStateChangeTime();
}

