/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionSingleNode;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PartitionGroupNode
implements PartitionNode {
    @GridToStringInclude
    private final Set<PartitionSingleNode> siblings;

    public PartitionGroupNode(Set<PartitionSingleNode> siblings) {
        assert (!F.isEmpty(siblings));
        this.siblings = siblings;
    }

    @Override
    public Collection<Integer> apply(PartitionClientContext ctx, Object ... args) throws IgniteCheckedException {
        HashSet<Integer> res = new HashSet<Integer>(this.siblings.size());
        for (PartitionSingleNode sibling : this.siblings) {
            Integer part = sibling.applySingle(ctx, args);
            if (part == null) {
                return null;
            }
            res.add(part);
        }
        return res;
    }

    @Override
    public int joinGroup() {
        return this.siblings.iterator().next().joinGroup();
    }

    public Set<PartitionSingleNode> siblings() {
        return this.siblings;
    }

    public boolean contains(PartitionSingleNode val) {
        return this.siblings.contains(val);
    }

    public boolean containsExact(Collection<PartitionSingleNode> siblings) {
        return this.siblings.size() == siblings.size() && this.siblings.containsAll(siblings);
    }

    public boolean constantsOnly() {
        for (PartitionSingleNode sibling : this.siblings) {
            if (sibling.constant()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return S.toString(PartitionGroupNode.class, this);
    }

    @Override
    public String cacheName() {
        return this.siblings.iterator().next().cacheName();
    }
}

