/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.meta.MetaDetailsCommandArg;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"typeId", "typeName"}, onlyOneOf=true, optional=false)
public class MetaRemoveCommandArg
extends MetaDetailsCommandArg {
    private static final long serialVersionUID = 0L;
    @Argument(optional=true, example="<fileName>")
    private String out;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        super.writeExternalData(out);
        U.writeString(out, this.out);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalData(protoVer, in);
        this.out = U.readString(in);
    }

    public String out() {
        return this.out;
    }

    public void out(String out) {
        Path outFile = FileSystems.getDefault().getPath(out, new String[0]);
        try (OutputStream os = Files.newOutputStream(outFile, new OpenOption[0]);){
            os.close();
            Files.delete(outFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot write to output file " + outFile + ". Error: " + e.toString(), e);
        }
        this.out = out;
    }
}

