/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.CacheDefaultBinaryAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryTypeCandidate;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryTypeIdKey;
import org.apache.ignite.internal.processors.query.property.QueryBinaryProperty;
import org.apache.ignite.internal.processors.query.property.QueryClassProperty;
import org.apache.ignite.internal.processors.query.property.QueryFieldAccessor;
import org.apache.ignite.internal.processors.query.property.QueryMethodsAccessor;
import org.apache.ignite.internal.processors.query.property.QueryPropertyAccessor;
import org.apache.ignite.internal.processors.query.property.QueryReadOnlyMethodsAccessor;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryUtils {
    public static final int DEFAULT_COLUMNS_COUNT = 2;
    public static final int KEY_COL = 0;
    public static final int VAL_COL = 1;
    public static final String DFLT_SCHEMA = "PUBLIC";
    public static final String PRIMARY_KEY_INDEX = "_key_PK";
    public static final String AFFINITY_KEY_INDEX = "AFFINITY_KEY";
    public static final String SCHEMA_SYS = IgniteSystemProperties.getBoolean("IGNITE_SQL_SYSTEM_SCHEMA_NAME_IGNITE") ? "IGNITE" : "SYS";
    public static final String SCHEMA_INFORMATION = "INFORMATION_SCHEMA";
    public static final String KEY_FIELD_NAME = "_KEY";
    public static final String VAL_FIELD_NAME = "_VAL";
    public static final String TEMPLATE_PARTITIONED = "PARTITIONED";
    public static final String TEMPLATE_REPLICATED = "REPLICATED";
    public static final int DFLT_INDEXING_DISCOVERY_HISTORY_SIZE = 1000;
    private static final int DISCO_HIST_SIZE = IgniteSystemProperties.getInteger("IGNITE_INDEXING_DISCOVERY_HISTORY_SIZE", 1000);
    private static final Class<?> GEOMETRY_CLASS = U.classForName("org.locationtech.jts.geom.Geometry", null);
    private static final Set<Class<?>> SQL_TYPES = QueryUtils.createSqlTypes();
    public static final char DEFAULT_DELIM = '\n';
    public static final char SPACE_DELIM = ' ';
    public static boolean INCLUDE_SENSITIVE = IgniteSystemProperties.getBoolean("IGNITE_TO_STRING_INCLUDE_SENSITIVE", true);
    public static final ThreadLocal<Boolean> INCLUDE_SENSITIVE_TL = ThreadLocal.withInitial(() -> true);

    @NotNull
    private static Set<Class<?>> createSqlTypes() {
        HashSet sqlClasses = new HashSet(Arrays.asList(Integer.class, Boolean.class, Byte.class, Short.class, Long.class, BigDecimal.class, Double.class, Float.class, Time.class, Timestamp.class, java.util.Date.class, Date.class, LocalTime.class, LocalDate.class, LocalDateTime.class, String.class, UUID.class, byte[].class));
        return sqlClasses;
    }

    public static String tableName(QueryEntity entity) {
        String res = entity.getTableName();
        if (res == null) {
            String valTyp = entity.findValueType();
            if (valTyp == null) {
                throw new IgniteException("Value type cannot be null or empty [queryEntity=" + entity + "]");
            }
            res = QueryUtils.typeName(entity.findValueType());
        }
        return res;
    }

    public static String indexName(QueryEntity entity, QueryIndex idx) {
        return QueryUtils.indexName(QueryUtils.tableName(entity), idx);
    }

    public static String indexName(String tblName, QueryIndex idx) {
        String res = idx.getName();
        if (res == null) {
            StringBuilder idxName = new StringBuilder(tblName + "_");
            for (Map.Entry<String, Boolean> field : idx.getFields().entrySet()) {
                idxName.append(field.getKey());
                idxName.append('_');
                idxName.append(field.getValue() != false ? "asc_" : "desc_");
            }
            for (int i = 0; i < idxName.length(); ++i) {
                char ch = idxName.charAt(i);
                if (Character.isWhitespace(ch)) {
                    idxName.setCharAt(i, '_');
                    continue;
                }
                idxName.setCharAt(i, Character.toLowerCase(ch));
            }
            idxName.append("idx");
            return idxName.toString();
        }
        return res;
    }

    public static Collection<QueryEntity> normalizeQueryEntities(GridKernalContext ctx, Collection<QueryEntity> entities, CacheConfiguration<?, ?> cfg) {
        ArrayList<QueryEntity> normalEntities = new ArrayList<QueryEntity>(entities.size());
        for (QueryEntity entity : entities) {
            if (!F.isEmpty(entity.getNotNullFields())) {
                QueryUtils.checkNotNullAllowed(cfg);
            }
            normalEntities.add(QueryUtils.normalizeQueryEntity(ctx, entity, cfg.isSqlEscapeAll()));
        }
        return normalEntities;
    }

    public static QueryEntity normalizeQueryEntity(GridKernalContext ctx, QueryEntity entity, boolean escape) {
        String normalTblName;
        if (escape) {
            String tblName = QueryUtils.tableName(entity);
            entity.setTableName(tblName);
            HashMap<String, String> aliases = new HashMap<String, String>(entity.getAliases());
            for (String fieldName : entity.getFields().keySet()) {
                String fieldAlias = entity.getAliases().get(fieldName);
                if (fieldAlias != null) continue;
                fieldAlias = QueryUtils.aliasForFieldName(fieldName);
                aliases.put(fieldName, fieldAlias);
            }
            entity.setAliases(aliases);
            for (QueryIndex idx : entity.getIndexes()) {
                idx.setName(QueryUtils.indexName(tblName, idx));
            }
            QueryUtils.validateQueryEntity(entity);
            return entity;
        }
        QueryEntityEx normalEntity = new QueryEntityEx();
        normalEntity.setKeyType(entity.getKeyType());
        normalEntity.setValueType(entity.getValueType());
        normalEntity.setFields(entity.getFields());
        normalEntity.setKeyFields(entity.getKeyFields());
        normalEntity.setKeyFieldName(entity.getKeyFieldName());
        normalEntity.setValueFieldName(entity.getValueFieldName());
        normalEntity.setNotNullFields(entity.getNotNullFields());
        normalEntity.setDefaultFieldValues(entity.getDefaultFieldValues());
        normalEntity.setFieldsPrecision(entity.getFieldsPrecision());
        normalEntity.setFieldsScale(entity.getFieldsScale());
        if (entity instanceof QueryEntityEx) {
            normalEntity.setPrimaryKeyInlineSize(((QueryEntityEx)entity).getPrimaryKeyInlineSize());
            normalEntity.setAffinityKeyInlineSize(((QueryEntityEx)entity).getAffinityKeyInlineSize());
        }
        normalTblName = (normalTblName = entity.getTableName()) == null ? QueryUtils.normalizeObjectName(QueryUtils.tableName(entity), true) : QueryUtils.normalizeObjectName(normalTblName, false);
        normalEntity.setTableName(normalTblName);
        HashMap<String, String> normalAliases = new HashMap<String, String>(normalEntity.getAliases());
        for (String fieldName : normalEntity.getFields().keySet()) {
            String fieldAlias = entity.getAliases().get(fieldName);
            if (fieldAlias == null) {
                fieldAlias = QueryUtils.aliasForFieldName(fieldName);
            }
            assert (fieldAlias != null);
            normalAliases.put(fieldName, QueryUtils.normalizeObjectName(fieldAlias, false));
        }
        normalEntity.setAliases(normalAliases);
        LinkedList<QueryIndex> normalIdxs = new LinkedList<QueryIndex>();
        for (QueryIndex idx : entity.getIndexes()) {
            QueryIndex normalIdx = new QueryIndex();
            normalIdx.setFields(idx.getFields());
            normalIdx.setIndexType(idx.getIndexType());
            normalIdx.setInlineSize(idx.getInlineSize());
            normalIdx.setName(QueryUtils.normalizeObjectName(QueryUtils.indexName(normalTblName, idx), false));
            normalIdxs.add(normalIdx);
        }
        normalEntity.setIndexes(normalIdxs);
        QueryUtils.validateQueryEntity(normalEntity);
        if (!ctx.recoveryMode()) {
            normalEntity.fillAbsentPKsWithDefaults(true);
        } else if (entity instanceof QueryEntityEx) {
            normalEntity.fillAbsentPKsWithDefaults(((QueryEntityEx)entity).fillAbsentPKsWithDefaults());
        }
        return normalEntity;
    }

    public static String normalizeSchemaName(String cacheName, @Nullable String schemaName) {
        boolean escape = false;
        String res = schemaName;
        if (res == null) {
            res = cacheName;
            escape = true;
        } else if (res.startsWith("\"") && res.endsWith("\"")) {
            res = res.substring(1, res.length() - 1);
            escape = true;
        }
        if (!escape) {
            res = QueryUtils.normalizeObjectName(res, false);
        }
        return res;
    }

    private static String aliasForFieldName(String fieldName) {
        int idx = fieldName.lastIndexOf(46);
        if (idx >= 0) {
            fieldName = fieldName.substring(idx + 1);
        }
        return fieldName;
    }

    @Nullable
    public static String normalizeObjectName(@Nullable String str, boolean replace) {
        if (str == null) {
            return null;
        }
        if (replace) {
            str = str.replace('.', '_').replace('$', '_');
        }
        return str.toUpperCase();
    }

    public static QueryTypeCandidate typeForQueryEntity(GridKernalContext ctx, String cacheName, String schemaName, GridCacheContextInfo cacheInfo, QueryEntity qryEntity, List<Class<?>> mustDeserializeClss, boolean escape) throws IgniteCheckedException {
        QueryTypeIdKey typeId;
        boolean keyOrValMustDeserialize;
        CacheConfiguration ccfg = cacheInfo.config();
        boolean binaryEnabled = ctx.cacheObjects().isBinaryEnabled(ccfg);
        CacheObjectContext coCtx = ctx.cacheObjects().contextForCache(ccfg);
        QueryTypeDescriptorImpl desc = new QueryTypeDescriptorImpl(cacheName, coCtx);
        desc.schemaName(schemaName);
        desc.aliases(qryEntity.getAliases());
        if (qryEntity instanceof QueryEntityEx) {
            desc.setFillAbsentPKsWithDefaults(((QueryEntityEx)qryEntity).fillAbsentPKsWithDefaults());
        }
        Class<Object> keyCls = U.box(U.classForName(qryEntity.findKeyType(), null, true));
        Class<?> valCls = U.box(U.classForName(qryEntity.findValueType(), null, true));
        boolean keyMustDeserialize = QueryUtils.mustDeserializeBinary(ctx, keyCls);
        boolean valMustDeserialize = QueryUtils.mustDeserializeBinary(ctx, valCls);
        boolean bl = keyOrValMustDeserialize = keyMustDeserialize || valMustDeserialize;
        if (keyCls == null) {
            keyCls = Object.class;
        }
        String simpleValType = valCls == null ? QueryUtils.typeName(qryEntity.findValueType()) : QueryUtils.typeName(valCls);
        desc.name(simpleValType);
        desc.tableName(qryEntity.getTableName());
        if (binaryEnabled && !keyOrValMustDeserialize) {
            if (SQL_TYPES.contains(valCls)) {
                desc.valueClass(valCls);
            } else {
                desc.valueClass(Object.class);
            }
            if (SQL_TYPES.contains(keyCls)) {
                desc.keyClass(keyCls);
            } else {
                desc.keyClass(Object.class);
            }
        } else {
            if (valCls == null) {
                throw new IgniteCheckedException("Failed to find value class in the node classpath (use default marshaller to enable binary objects) : " + qryEntity.findValueType());
            }
            desc.valueClass(valCls);
            desc.keyClass(keyCls);
        }
        desc.keyTypeName(qryEntity.findKeyType());
        desc.valueTypeName(qryEntity.findValueType());
        desc.keyFieldName(qryEntity.getKeyFieldName());
        desc.valueFieldName(qryEntity.getValueFieldName());
        if (binaryEnabled && keyOrValMustDeserialize) {
            if (keyMustDeserialize) {
                mustDeserializeClss.add(keyCls);
            }
            if (valMustDeserialize) {
                mustDeserializeClss.add(valCls);
            }
        }
        QueryTypeIdKey altTypeId = null;
        int valTypeId = ctx.cacheObjects().typeId(qryEntity.findValueType());
        if (valCls == null || binaryEnabled && !keyOrValMustDeserialize) {
            QueryUtils.processBinaryMeta(ctx, qryEntity, desc);
            typeId = new QueryTypeIdKey(cacheName, valTypeId);
            if (valCls != null) {
                altTypeId = new QueryTypeIdKey(cacheName, valCls);
            }
            String affField = null;
            if (!coCtx.customAffinityMapper()) {
                CacheDefaultBinaryAffinityKeyMapper mapper;
                BinaryField field;
                String keyType = qryEntity.getKeyType();
                if (keyType != null && (field = (mapper = (CacheDefaultBinaryAffinityKeyMapper)coCtx.defaultAffMapper()).affinityKeyField(keyType)) != null) {
                    String affField0 = field.name();
                    if (!F.isEmpty(qryEntity.getKeyFields()) && qryEntity.getKeyFields().contains(affField0)) {
                        affField = desc.aliases().getOrDefault(affField0, affField0);
                        if (!escape) {
                            affField = QueryUtils.normalizeObjectName(affField, false);
                        }
                    }
                }
            } else {
                desc.customAffinityKeyMapper(true);
            }
            desc.affinityKey(affField);
        } else {
            QueryUtils.processClassMeta(qryEntity, desc, coCtx);
            AffinityKeyMapper keyMapper = cacheInfo.config().getAffinityMapper();
            if (keyMapper instanceof GridCacheDefaultAffinityKeyMapper) {
                String affField = ((GridCacheDefaultAffinityKeyMapper)keyMapper).affinityKeyPropertyName(desc.keyClass());
                if (affField != null) {
                    affField = desc.aliases().getOrDefault(affField, affField);
                    if (!escape) {
                        affField = QueryUtils.normalizeObjectName(affField, false);
                    }
                    desc.affinityKey(affField);
                }
            } else {
                desc.customAffinityKeyMapper(true);
            }
            typeId = new QueryTypeIdKey(cacheName, valCls);
            altTypeId = new QueryTypeIdKey(cacheName, valTypeId);
        }
        desc.typeId(valTypeId);
        if (qryEntity instanceof QueryEntityEx) {
            QueryEntityEx qe = (QueryEntityEx)qryEntity;
            desc.primaryKeyInlineSize(qe.getPrimaryKeyInlineSize() != null ? qe.getPrimaryKeyInlineSize() : -1);
            desc.affinityFieldInlineSize(qe.getAffinityKeyInlineSize() != null ? qe.getAffinityKeyInlineSize() : -1);
        } else {
            desc.primaryKeyInlineSize(-1);
            desc.affinityFieldInlineSize(-1);
        }
        return new QueryTypeCandidate(typeId, altTypeId, desc);
    }

    public static void processBinaryMeta(GridKernalContext ctx, QueryEntity qryEntity, QueryTypeDescriptorImpl d) throws IgniteCheckedException {
        LinkedHashMap<String, String> fields = qryEntity.getFields();
        Set<String> keyFields = qryEntity.getKeyFields();
        Set<String> notNulls = qryEntity.getNotNullFields();
        Map<String, Object> dlftVals = qryEntity.getDefaultFieldValues();
        Map<String, Integer> precision = qryEntity.getFieldsPrecision();
        Map<String, Integer> scale = qryEntity.getFieldsScale();
        boolean hasKeyFields = keyFields != null;
        boolean isKeyClsSqlType = QueryUtils.isSqlType(d.keyClass());
        if (hasKeyFields && !isKeyClsSqlType) {
            for (String string : keyFields) {
                if (fields.containsKey(string)) continue;
                throw new IgniteCheckedException("QueryEntity 'keyFields' property must be a subset of keys from 'fields' property (case sensitive): " + string);
            }
        }
        for (Map.Entry entry : fields.entrySet()) {
            String fieldName = (String)entry.getKey();
            String fieldType = (String)entry.getValue();
            boolean isKeyField = isKeyClsSqlType ? false : hasKeyFields && keyFields.contains(fieldName);
            boolean notNull = notNulls != null && notNulls.contains(fieldName);
            Object dfltVal = dlftVals != null ? dlftVals.get(fieldName) : null;
            QueryBinaryProperty prop = QueryUtils.buildBinaryProperty(ctx, fieldName, U.classForName(fieldType, Object.class, true), d.aliases(), isKeyField, notNull, dfltVal, precision == null ? -1 : precision.getOrDefault(fieldName, -1), scale == null ? -1 : scale.getOrDefault(fieldName, -1));
            d.addProperty(prop, false);
        }
        if (!isKeyClsSqlType && qryEntity instanceof QueryEntityEx && ((QueryEntityEx)qryEntity).isPreserveKeysOrder()) {
            d.primaryKeyFields(keyFields);
        }
        if (qryEntity instanceof QueryEntityEx) {
            d.implicitPk(((QueryEntityEx)qryEntity).implicitPk());
        }
        if (qryEntity.getKeyFieldName() == null && F.mapContainsKey(precision, KEY_FIELD_NAME) || F.isEmpty(fields)) {
            QueryUtils.addKeyValueProperty(ctx, qryEntity, d, KEY_FIELD_NAME, true);
        }
        if (qryEntity.getValueFieldName() == null && F.mapContainsKey(precision, VAL_FIELD_NAME) || F.isEmpty(fields)) {
            QueryUtils.addKeyValueProperty(ctx, qryEntity, d, VAL_FIELD_NAME, false);
        }
        QueryUtils.processIndexes(qryEntity, d);
    }

    private static void addKeyValueProperty(GridKernalContext ctx, QueryEntity qryEntity, QueryTypeDescriptorImpl d, String name, boolean isKey) throws IgniteCheckedException {
        Map<String, Object> dfltVals = qryEntity.getDefaultFieldValues();
        Map<String, Integer> precision = qryEntity.getFieldsPrecision();
        Map<String, Integer> scale = qryEntity.getFieldsScale();
        String typeName = isKey ? qryEntity.getKeyType() : qryEntity.getValueType();
        Object dfltVal = dfltVals.get(name);
        QueryBinaryProperty prop = QueryUtils.buildBinaryProperty(ctx, name, U.classForName(typeName, Object.class, true), d.aliases(), isKey, true, dfltVal, precision == null ? -1 : precision.getOrDefault(name, -1), scale == null ? -1 : scale.getOrDefault(name, -1));
        d.addProperty(prop, true, false);
    }

    public static void processClassMeta(QueryEntity qryEntity, QueryTypeDescriptorImpl d, CacheObjectContext coCtx) throws IgniteCheckedException {
        Set<String> notNulls = qryEntity.getNotNullFields();
        for (Map.Entry<String, String> entry : qryEntity.getFields().entrySet()) {
            GridQueryProperty prop = QueryUtils.buildProperty(d.keyClass(), d.valueClass(), d.keyFieldName(), d.valueFieldName(), entry.getKey(), U.classForName(entry.getValue(), Object.class), d.aliases(), notNulls != null && notNulls.contains(entry.getKey()), coCtx);
            d.addProperty(prop, false);
        }
        QueryUtils.processIndexes(qryEntity, d);
    }

    private static void processIndexes(QueryEntity qryEntity, QueryTypeDescriptorImpl d) throws IgniteCheckedException {
        if (!F.isEmpty(qryEntity.getIndexes())) {
            for (QueryIndex idx : qryEntity.getIndexes()) {
                QueryUtils.processIndex(idx, d);
            }
        }
    }

    public static void processDynamicIndexChange(String idxName, @Nullable QueryIndex idx, QueryTypeDescriptorImpl d) throws IgniteCheckedException {
        d.dropIndex(idxName);
        if (idx != null) {
            QueryUtils.processIndex(idx, d);
        }
    }

    public static QueryIndexDescriptorImpl createIndexDescriptor(QueryTypeDescriptorImpl typeDesc, QueryIndex idx) throws IgniteCheckedException {
        String idxName = QueryUtils.indexName(typeDesc.tableName(), idx);
        QueryIndexType idxTyp = idx.getIndexType();
        assert (idxTyp == QueryIndexType.SORTED || idxTyp == QueryIndexType.GEOSPATIAL);
        QueryIndexDescriptorImpl res = new QueryIndexDescriptorImpl(typeDesc, idxName, idxTyp, idx.getInlineSize());
        int i = 0;
        for (Map.Entry<String, Boolean> entry : idx.getFields().entrySet()) {
            String field = entry.getKey();
            boolean asc = entry.getValue();
            String alias = typeDesc.aliases().get(field);
            if (alias != null) {
                field = alias;
            }
            res.addField(field, i++, !asc);
        }
        return res;
    }

    private static void processIndex(QueryIndex idx, QueryTypeDescriptorImpl d) throws IgniteCheckedException {
        QueryIndexType idxTyp = idx.getIndexType();
        if (idxTyp == QueryIndexType.SORTED || idxTyp == QueryIndexType.GEOSPATIAL) {
            QueryIndexDescriptorImpl idxDesc = QueryUtils.createIndexDescriptor(d, idx);
            d.addIndex(idxDesc);
        } else if (idxTyp == QueryIndexType.FULLTEXT) {
            for (String field : idx.getFields().keySet()) {
                String alias = d.aliases().get(field);
                if (alias != null) {
                    field = alias;
                }
                d.addFieldToTextIndex(field);
            }
        } else {
            if (idxTyp != null) {
                throw new IllegalArgumentException("Unsupported index type [idx=" + idx.getName() + ", typ=" + idxTyp + "]");
            }
            throw new IllegalArgumentException("Index type is not set: " + idx.getName());
        }
    }

    public static QueryBinaryProperty buildBinaryProperty(GridKernalContext ctx, String pathStr, Class<?> resType, Map<String, String> aliases, boolean isKeyField, boolean notNull, Object dlftVal, int precision, int scale) {
        String[] path = pathStr.split("\\.");
        QueryBinaryProperty res = null;
        StringBuilder fullName = new StringBuilder();
        for (String prop : path) {
            if (fullName.length() != 0) {
                fullName.append('.');
            }
            fullName.append(prop);
            String alias = aliases.get(fullName.toString());
            res = new QueryBinaryProperty(ctx, prop, res, resType, isKeyField, alias, notNull, dlftVal, precision, scale);
        }
        return res;
    }

    public static QueryClassProperty buildClassProperty(Class<?> keyCls, Class<?> valCls, String pathStr, Class<?> resType, Map<String, String> aliases, boolean notNull, CacheObjectContext coCtx) throws IgniteCheckedException {
        QueryClassProperty res = QueryUtils.buildClassProperty(false, valCls, pathStr, resType, aliases, notNull, coCtx);
        if (res == null) {
            res = QueryUtils.buildClassProperty(true, keyCls, pathStr, resType, aliases, notNull, coCtx);
        }
        if (res == null) {
            throw new IgniteCheckedException(QueryUtils.propertyInitializationExceptionMessage(keyCls, valCls, pathStr, resType));
        }
        return res;
    }

    public static GridQueryProperty buildProperty(Class<?> keyCls, Class<?> valCls, String keyFieldName, String valueFieldName, String pathStr, Class<?> resType, Map<String, String> aliases, boolean notNull, CacheObjectContext coCtx) throws IgniteCheckedException {
        if (pathStr.equals(keyFieldName)) {
            return new KeyOrValProperty(true, pathStr, keyCls);
        }
        if (pathStr.equals(valueFieldName)) {
            return new KeyOrValProperty(false, pathStr, valCls);
        }
        return QueryUtils.buildClassProperty(keyCls, valCls, pathStr, resType, aliases, notNull, coCtx);
    }

    public static String propertyInitializationExceptionMessage(Class<?> keyCls, Class<?> valCls, String pathStr, Class<?> resType) {
        return "Failed to initialize property '" + pathStr + "' of type '" + resType.getName() + "' for key class '" + keyCls + "' and value class '" + valCls + "'. Make sure that one of these classes contains respective getter method or field.";
    }

    public static QueryClassProperty buildClassProperty(boolean key, Class<?> cls, String pathStr, Class<?> resType, Map<String, String> aliases, boolean notNull, CacheObjectContext coCtx) {
        String[] path = pathStr.split("\\.");
        QueryClassProperty res = null;
        StringBuilder fullName = new StringBuilder();
        for (String prop : path) {
            if (fullName.length() != 0) {
                fullName.append('.');
            }
            fullName.append(prop);
            String alias = aliases.get(fullName.toString());
            QueryPropertyAccessor accessor = QueryUtils.findProperty(prop, cls);
            if (accessor == null) {
                return null;
            }
            QueryClassProperty tmp = new QueryClassProperty(accessor, key, alias, notNull, coCtx);
            tmp.parent(res);
            cls = tmp.type();
            res = tmp;
        }
        if (!U.box(resType).isAssignableFrom(U.box(res.type()))) {
            return null;
        }
        return res;
    }

    @Nullable
    private static QueryPropertyAccessor findProperty(String prop, Class<?> cls) {
        StringBuilder getBldr = new StringBuilder("get");
        getBldr.append(prop);
        getBldr.setCharAt(3, Character.toUpperCase(getBldr.charAt(3)));
        StringBuilder setBldr = new StringBuilder("set");
        setBldr.append(prop);
        setBldr.setCharAt(3, Character.toUpperCase(setBldr.charAt(3)));
        try {
            Method setter;
            Method getter = cls.getMethod(getBldr.toString(), new Class[0]);
            try {
                setter = cls.getMethod(setBldr.toString(), getter.getReturnType());
            }
            catch (NoSuchMethodException ignore) {
                return new QueryReadOnlyMethodsAccessor(getter, prop);
            }
            return new QueryMethodsAccessor(getter, setter, prop);
        }
        catch (NoSuchMethodException getter) {
            getBldr = new StringBuilder("is");
            getBldr.append(prop);
            getBldr.setCharAt(2, Character.toUpperCase(getBldr.charAt(2)));
            try {
                Method setter;
                Method getter2 = cls.getMethod(getBldr.toString(), new Class[0]);
                try {
                    setter = cls.getMethod(setBldr.toString(), getter2.getReturnType());
                }
                catch (NoSuchMethodException ignore) {
                    return new QueryReadOnlyMethodsAccessor(getter2, prop);
                }
                return new QueryMethodsAccessor(getter2, setter, prop);
            }
            catch (NoSuchMethodException getter2) {
                for (Class<?> cls0 = cls; cls0 != null; cls0 = cls0.getSuperclass()) {
                    try {
                        return new QueryFieldAccessor(cls0.getDeclaredField(prop));
                    }
                    catch (NoSuchFieldException ignored) {
                        continue;
                    }
                }
                try {
                    Method setter;
                    Method getter3 = cls.getMethod(prop, new Class[0]);
                    try {
                        setter = cls.getMethod(prop, getter3.getReturnType());
                    }
                    catch (NoSuchMethodException ignore) {
                        return new QueryReadOnlyMethodsAccessor(getter3, prop);
                    }
                    return new QueryMethodsAccessor(getter3, setter, prop);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        }
    }

    private static boolean mustDeserializeBinary(GridKernalContext ctx, Class cls) {
        if (cls != null && cls != Object.class && ctx.config().getMarshaller() instanceof BinaryMarshaller) {
            CacheObjectBinaryProcessorImpl proc0 = (CacheObjectBinaryProcessorImpl)ctx.cacheObjects();
            return proc0.binaryContext().mustDeserialize(cls);
        }
        return false;
    }

    public static boolean isSqlType(Class<?> cls) {
        return SQL_TYPES.contains(cls = U.box(cls)) || QueryUtils.isGeometryClass(cls);
    }

    public static boolean isGeometryClass(Class<?> cls) {
        return GEOMETRY_CLASS != null && GEOMETRY_CLASS.isAssignableFrom(cls);
    }

    public static String typeName(String clsName) {
        int parentEnd;
        int pkgEnd;
        int genericStart = ((String)clsName).indexOf(96);
        if (genericStart >= 0) {
            clsName = ((String)clsName).substring(0, genericStart);
        }
        if ((pkgEnd = ((String)clsName).lastIndexOf(46)) >= 0 && pkgEnd < ((String)clsName).length() - 1) {
            clsName = ((String)clsName).substring(pkgEnd + 1);
        }
        if (((String)clsName).endsWith("[]")) {
            clsName = ((String)clsName).substring(0, ((String)clsName).length() - 2) + "_array";
        }
        if ((parentEnd = ((String)clsName).lastIndexOf(36)) >= 0) {
            clsName = ((String)clsName).substring(parentEnd + 1);
        }
        if ((parentEnd = ((String)clsName).lastIndexOf(43)) >= 0) {
            clsName = ((String)clsName).substring(parentEnd + 1);
        }
        return clsName;
    }

    public static String typeName(Class<?> cls) {
        Object typeName = cls.getSimpleName();
        if (F.isEmpty((String)typeName)) {
            String pkg = cls.getPackage().getName();
            typeName = cls.getName().substring(pkg.length() + (pkg.isEmpty() ? 0 : 1));
        }
        if (cls.isArray()) {
            assert (((String)typeName).endsWith("[]"));
            typeName = ((String)typeName).substring(0, ((String)typeName).length() - 2) + "_array";
        }
        return typeName;
    }

    public static int validateTimeout(int timeout, TimeUnit timeUnit) {
        A.ensure(timeUnit != TimeUnit.MICROSECONDS && timeUnit != TimeUnit.NANOSECONDS, "timeUnit minimal resolution is millisecond.");
        A.ensure(timeout >= 0, "timeout value should be non-negative.");
        long tmp = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        return (int)tmp;
    }

    public static boolean isEnabled(CacheConfiguration<?, ?> ccfg) {
        return !F.isEmpty(ccfg.getIndexedTypes()) || !F.isEmpty(ccfg.getQueryEntities());
    }

    public static int discoveryHistorySize() {
        return DISCO_HIST_SIZE;
    }

    @Nullable
    public static SchemaOperationException wrapIfNeeded(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof SchemaOperationException) {
            return (SchemaOperationException)e;
        }
        return new SchemaOperationException("Unexpected exception.", e);
    }

    public static SchemaOperationException checkQueryEntityConflicts(CacheConfiguration<?, ?> ccfg, Collection<DynamicCacheDescriptor> descs) {
        String schema = QueryUtils.normalizeSchemaName(ccfg.getName(), ccfg.getSqlSchema());
        HashSet<String> idxNames = new HashSet<String>();
        HashSet<String> tblNames = new HashSet<String>();
        for (DynamicCacheDescriptor desc : descs) {
            String descSchema;
            if (F.eq(ccfg.getName(), desc.cacheName()) || !F.eq(schema, descSchema = QueryUtils.normalizeSchemaName(desc.cacheName(), desc.cacheConfiguration().getSqlSchema()))) continue;
            for (QueryEntity e : desc.schema().entities()) {
                tblNames.add(e.getTableName());
                for (QueryIndex idx : e.getIndexes()) {
                    idxNames.add(idx.getName());
                }
            }
        }
        for (QueryEntity e : ccfg.getQueryEntities()) {
            if (!tblNames.add(e.getTableName())) {
                return new SchemaOperationException(3, e.getTableName());
            }
            for (QueryIndex idx : e.getIndexes()) {
                if (idxNames.add(idx.getName())) continue;
                return new SchemaOperationException(7, idx.getName());
            }
        }
        return null;
    }

    private static void validateQueryEntity(QueryEntity entity) {
        if (F.isEmpty(entity.findValueType())) {
            throw new IgniteException("Value type cannot be null or empty [queryEntity=" + entity + "]");
        }
        String keyFieldName = entity.getKeyFieldName();
        if (keyFieldName != null && !entity.getFields().containsKey(keyFieldName)) {
            throw new IgniteException("Key field is not in the field list [queryEntity=" + entity + ", keyFieldName=" + keyFieldName + "]");
        }
        String valFieldName = entity.getValueFieldName();
        if (valFieldName != null && !entity.getFields().containsKey(valFieldName)) {
            throw new IgniteException("Value field is not in the field list [queryEntity=" + entity + ", valFieldName=" + valFieldName + "]");
        }
        QueryUtils.validateAliases(entity);
        Collection<QueryIndex> idxs = entity.getIndexes();
        if (!F.isEmpty(idxs)) {
            HashSet<String> idxNames = new HashSet<String>();
            for (QueryIndex idx : idxs) {
                String idxName = idx.getName();
                if (idxName == null) {
                    idxName = QueryUtils.indexName(entity, idx);
                }
                assert (!F.isEmpty(idxName));
                if (!idxNames.add(idxName)) {
                    throw new IgniteException("Duplicate index name [queryEntity=" + entity + ", queryIdx=" + idx + "]");
                }
                if (idx.getIndexType() != null) continue;
                throw new IgniteException("Index type is not set [queryEntity=" + entity + ", queryIdx=" + idx + "]");
            }
        }
        Map<String, Object> dfltVals = entity.getDefaultFieldValues();
        Map<String, Integer> precision = entity.getFieldsPrecision();
        Map<String, Integer> scale = entity.getFieldsScale();
        if (!F.isEmpty(precision)) {
            for (String fld : precision.keySet()) {
                Object dfltVal;
                if (!dfltVals.containsKey(fld) || (dfltVal = dfltVals.get(fld)) == null) continue;
                if (dfltVal.getClass() == String.class && dfltVal.toString().length() > precision.get(fld)) {
                    throw new IgniteSQLException("Default value '" + dfltVal + "' is longer than maximum length " + precision.get(fld), 4008);
                }
                if (dfltVal.getClass() != BigDecimal.class) continue;
                BigDecimal dec = (BigDecimal)dfltVal;
                if (dec.precision() > precision.get(fld)) {
                    throw new IgniteSQLException("Default value: '" + dfltVal + "' for a column " + fld + " is out of range. Maximum precision: " + precision.get(fld) + ", actual precision: " + dec.precision(), 4008);
                }
                if (F.isEmpty(scale) || !scale.containsKey(fld) || dec.scale() <= scale.get(fld)) continue;
                throw new IgniteSQLException("Default value:: '" + dfltVal + "' for a column " + fld + " is out of range. Maximum scale: " + scale.get(fld) + ", actual scale: " + dec.scale(), 4009);
            }
        }
    }

    private static void validateAliases(QueryEntity entity) {
        HashSet<String> aliases = new HashSet<String>();
        for (String alias : entity.getAliases().values()) {
            if (aliases.add(alias)) continue;
            throw new IgniteException("Multiple query fields are associated with the same alias [alias=" + alias + "]");
        }
    }

    public static String createTableCacheName(String schemaName, String tblName) {
        return "SQL_" + schemaName + "_" + tblName;
    }

    public static String createTableValueTypeName(String schemaName, String tblName) {
        return QueryUtils.createTableCacheName(schemaName, tblName) + "_" + UUID.randomUUID().toString().replace("-", "_");
    }

    public static String createTableKeyTypeName(String valTypeName) {
        return valTypeName + KEY_FIELD_NAME;
    }

    public static QueryEntity copy(QueryEntity entity) {
        QueryEntity res = entity instanceof QueryEntityEx ? new QueryEntityEx(entity) : new QueryEntity(entity);
        return res;
    }

    public static void checkNotNullAllowed(CacheConfiguration cfg) {
        if (cfg.isReadThrough()) {
            throw new IgniteSQLException("NOT NULL constraint is not supported when CacheConfiguration.readThrough is enabled.", 1002);
        }
        if (cfg.getInterceptor() != null) {
            throw new IgniteSQLException("NOT NULL constraint is not supported when CacheConfiguration.interceptor is set.", 1002);
        }
    }

    public static boolean isCustomAffinityMapper(AffinityKeyMapper affinityKeyMapper) {
        return affinityKeyMapper != null && !(affinityKeyMapper instanceof CacheDefaultBinaryAffinityKeyMapper) && !(affinityKeyMapper instanceof GridCacheDefaultAffinityKeyMapper);
    }

    public static SchemaOperationException validateDropColumn(QueryEntity entity, String fieldName, String colName) {
        if (F.eq(fieldName, entity.getKeyFieldName()) || KEY_FIELD_NAME.equalsIgnoreCase(fieldName)) {
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because it represents an entire cache key");
        }
        if (F.eq(fieldName, entity.getValueFieldName()) || VAL_FIELD_NAME.equalsIgnoreCase(fieldName)) {
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because it represents an entire cache value");
        }
        Set<String> keyFields = entity.getKeyFields();
        if (keyFields != null && keyFields.contains(fieldName)) {
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because it is a part of a cache key");
        }
        Collection<QueryIndex> indexes = entity.getIndexes();
        if (indexes != null) {
            for (QueryIndex idxDesc : indexes) {
                if (!idxDesc.getFields().containsKey(fieldName)) continue;
                return new SchemaOperationException("Cannot drop column \"" + colName + "\" because an index exists (\"" + idxDesc.getName() + "\") that uses the column.");
            }
        }
        return null;
    }

    public static SchemaOperationException validateDropColumn(GridQueryTypeDescriptor type, String colName) {
        if (F.eq(colName, type.keyFieldName()) || KEY_FIELD_NAME.equalsIgnoreCase(colName)) {
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because it represents an entire cache key");
        }
        if (F.eq(colName, type.valueFieldName()) || VAL_FIELD_NAME.equalsIgnoreCase(colName)) {
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because it represents an entire cache value");
        }
        GridQueryProperty prop = type.property(colName);
        if (prop != null && prop.key()) {
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because it is a part of a cache key");
        }
        Collection<GridQueryIndexDescriptor> indexes = type.indexes().values();
        for (GridQueryIndexDescriptor idxDesc : indexes) {
            if (!idxDesc.fields().contains(colName)) continue;
            return new SchemaOperationException("Cannot drop column \"" + colName + "\" because an index exists (\"" + idxDesc.name() + "\") that uses the column.");
        }
        return null;
    }

    public static boolean wasCancelled(Throwable e) {
        return X.cause(e, QueryCancelledException.class) != null;
    }

    @NotNull
    public static SQLException toSqlException(Exception e) {
        int code;
        String sqlState;
        if (e instanceof IgniteSQLException) {
            sqlState = ((IgniteSQLException)e).sqlState();
            code = ((IgniteSQLException)e).statusCode();
        } else {
            sqlState = "50000";
            code = 1;
        }
        return new SQLException(e.getMessage(), sqlState, code, e);
    }

    public static String globalQueryId(UUID nodeId, long qryId) {
        return nodeId + "_" + qryId;
    }

    public static boolean matches(String str, String sqlPtrn) {
        if (str == null) {
            return false;
        }
        if (sqlPtrn == null) {
            return true;
        }
        String regex = SqlListenerUtils.translateSqlWildcardsToRegex(sqlPtrn);
        return str.matches(regex);
    }

    public static String fieldNameByAlias(QueryEntity entity, String alias) {
        if (!F.isEmpty(entity.getAliases())) {
            for (Map.Entry<String, String> aliasEntry : entity.getAliases().entrySet()) {
                if (!F.eq(aliasEntry.getValue(), alias)) continue;
                return aliasEntry.getKey();
            }
        }
        return alias;
    }

    public static IgniteSQLException convert(SchemaOperationException e) {
        int sqlCode;
        switch (e.code()) {
            case 1: {
                sqlCode = 4006;
                break;
            }
            case 2: {
                sqlCode = 3001;
                break;
            }
            case 3: {
                sqlCode = 3007;
                break;
            }
            case 4: {
                sqlCode = 3008;
                break;
            }
            case 5: {
                sqlCode = 3009;
                break;
            }
            case 6: {
                sqlCode = 3006;
                break;
            }
            case 7: {
                sqlCode = 3005;
                break;
            }
            case 9: {
                sqlCode = 3018;
                break;
            }
            case 10: {
                sqlCode = 3017;
                break;
            }
            case 11: {
                sqlCode = 3015;
                break;
            }
            default: {
                sqlCode = 1;
            }
        }
        return new IgniteSQLException(e.getMessage(), sqlCode, e);
    }

    public static void isDdlOnSchemaSupported(String schemaName) {
        if (F.eq(SCHEMA_SYS, schemaName)) {
            throw new IgniteSQLException("DDL statements are not supported on " + schemaName + " schema", 1002);
        }
    }

    public static boolean removeFieldAndAlias(QueryEntity entity, String alias) {
        String fieldName = QueryUtils.fieldNameByAlias(entity, alias);
        if (entity.getFields().remove(fieldName) != null) {
            entity.getAliases().remove(fieldName);
            return true;
        }
        return false;
    }

    public static SqlFieldsQuery withQueryTimeout(SqlFieldsQuery qry, int timeout, TimeUnit timeUnit) {
        if (timeout >= 0) {
            qry.setTimeout(timeout, timeUnit);
        }
        return qry;
    }

    public static boolean includeSensitive() {
        return INCLUDE_SENSITIVE || INCLUDE_SENSITIVE_TL.get() != false;
    }

    public static char delimeter() {
        if (!QueryUtils.includeSensitive()) {
            return ' ';
        }
        return '\n';
    }

    public static boolean isConvertibleTypes(Object val, Class<?> expCls) {
        if (val == null) {
            return true;
        }
        if (expCls == Date.class || expCls == LocalDate.class) {
            return val instanceof Date || val instanceof LocalDate;
        }
        if (expCls == Time.class || expCls == LocalTime.class) {
            return val instanceof Time || val instanceof LocalTime;
        }
        if (expCls == Timestamp.class || expCls == java.util.Date.class || expCls == LocalDateTime.class) {
            return val instanceof LocalDateTime || val instanceof java.util.Date;
        }
        return false;
    }

    private QueryUtils() {
    }

    public static class KeyOrValProperty
    implements GridQueryProperty {
        boolean isKey;
        String name;
        Class<?> cls;

        public KeyOrValProperty(boolean key, String name, Class<?> cls) {
            this.isKey = key;
            this.name = name;
            this.cls = cls;
        }

        @Override
        public Object value(Object key, Object val) throws IgniteCheckedException {
            return this.isKey ? key : val;
        }

        @Override
        public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<?> type() {
            return this.cls;
        }

        @Override
        public boolean key() {
            return this.isKey;
        }

        @Override
        public GridQueryProperty parent() {
            return null;
        }

        @Override
        public boolean notNull() {
            return true;
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public int precision() {
            return -1;
        }

        @Override
        public int scale() {
            return -1;
        }
    }
}

