/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.tracing;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.processors.tracing.DeferredSpan;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.NoopTracing;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanImpl;
import org.apache.ignite.internal.processors.tracing.SpanTags;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.processors.tracing.configuration.GridTracingConfigurationManager;
import org.apache.ignite.internal.processors.tracing.messages.TraceableMessagesHandler;
import org.apache.ignite.internal.util.GridClientByteUtils;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.tracing.NoopTracingSpi;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.SpiSpecificSpan;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationManager;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.apache.ignite.spi.tracing.TracingSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridTracingManager
extends GridManagerAdapter<TracingSpi>
implements Tracing {
    private static final int SPECIAL_FLAGS_OFF = 0;
    private static final int SPI_TYPE_OFF = 1;
    private static final int MAJOR_PROTOCOL_VERSION_OFF = 2;
    private static final int MINOR_PROTOCOL_VERSION_OFF = 3;
    private static final int SPI_SPECIFIC_SERIALIZED_SPAN_BYTES_LENGTH_OFF = 4;
    private static final int SPI_SPECIFIC_SERIALIZED_SPAN_BODY_OFF = 8;
    private static final int PARENT_SPAN_TYPE_BYTES_LENGTH = 4;
    private static final int INCLUDED_SCOPES_SIZE_BYTE_LENGTH = 4;
    private static final int SCOPE_INDEX_BYTE_LENGTH = 2;
    private static final int SPI_SPECIFIC_SERIALIZED_SPAN_BYTES_LENGTH = 4;
    private final TraceableMessagesHandler msgHnd;
    private final TracingConfigurationManager tracingConfiguration;
    private static final byte MAJOR_PROTOCOL_VERSION = 0;
    private static final byte MINOR_PROTOCOL_VERSION = 0;
    private static final TraceableMessagesHandler NOOP_TRACEABLE_MSG_HANDLER = new TraceableMessagesHandler(new NoopTracing(), new NullLogger());
    private boolean noop = true;

    public GridTracingManager(GridKernalContext ctx, boolean useNoopTracingSpi) {
        super(ctx, (IgniteSpi[])new TracingSpi[]{useNoopTracingSpi ? new NoopTracingSpi() : ctx.config().getTracingSpi()});
        this.msgHnd = new TraceableMessagesHandler(this, ctx.log(GridTracingManager.class));
        this.tracingConfiguration = new GridTracingConfigurationManager(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        try {
            this.startSpi();
            this.noop = this.getSpi() instanceof NoopTracingSpi;
        }
        catch (IgniteSpiException e) {
            this.log.warning("Failed to start tracing processor with spi: " + ((TracingSpi)this.getSpi()).getName() + ". Noop implementation will be used instead.", e);
            throw e;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    private Span enrichWithLocalNodeParameters(@Nullable Span span) {
        if (span == null) {
            return null;
        }
        span.addTag(SpanTags.NODE_ID, () -> this.ctx.localNodeId().toString());
        span.addTag(SpanTags.tag("node", "name"), this.ctx::igniteInstanceName);
        ClusterNode locNode = this.ctx.discovery().localNode();
        if (locNode != null && locNode.consistentId() != null) {
            span.addTag(SpanTags.tag("node", "consistent.id"), () -> locNode.consistentId().toString());
        }
        return span;
    }

    @Override
    public Span create(@NotNull SpanType spanType, @Nullable Span parentSpan) {
        if (this.noop) {
            return NoopSpan.INSTANCE;
        }
        if ((parentSpan == NoopSpan.INSTANCE || parentSpan == null) && this.tracingConfiguration.get(new TracingConfigurationCoordinates.Builder(spanType.scope()).build()).samplingRate() == 0.0) {
            return NoopSpan.INSTANCE;
        }
        return this.enrichWithLocalNodeParameters(this.generateSpan(parentSpan, spanType, null));
    }

    @Override
    public Span create(@NotNull SpanType spanType, @Nullable byte[] serializedParentSpan) {
        Span span;
        if (this.noop) {
            return NoopSpan.INSTANCE;
        }
        if ((serializedParentSpan.length == 0 || serializedParentSpan == null) && this.tracingConfiguration.get(new TracingConfigurationCoordinates.Builder(spanType.scope()).build()).samplingRate() == 0.0) {
            return NoopSpan.INSTANCE;
        }
        try {
            if (serializedParentSpan == null || serializedParentSpan.length == 0) {
                return this.create(spanType, NoopSpan.INSTANCE);
            }
            if (serializedParentSpan[1] != ((TracingSpi)this.getSpi()).type()) {
                return new DeferredSpan(serializedParentSpan);
            }
            if (serializedParentSpan[2] != 0) {
                return new DeferredSpan(serializedParentSpan);
            }
            byte minProtoVer = serializedParentSpan[3];
            int spiSpecificSpanSize = GridClientByteUtils.bytesToInt(Arrays.copyOfRange(serializedParentSpan, 4, 8), 0);
            SpanType parentSpanType = null;
            HashSet<Scope> includedScopes = new HashSet<Scope>();
            switch (minProtoVer) {
                case 0: {
                    parentSpanType = SpanType.fromIndex(GridClientByteUtils.bytesToInt(Arrays.copyOfRange(serializedParentSpan, 8 + spiSpecificSpanSize, 12 + spiSpecificSpanSize), 0));
                    int includedScopesSize = GridClientByteUtils.bytesToInt(Arrays.copyOfRange(serializedParentSpan, 12 + spiSpecificSpanSize, 16 + spiSpecificSpanSize), 0);
                    for (int i = 0; i < includedScopesSize; ++i) {
                        includedScopes.add(Scope.fromIndex(GridClientByteUtils.bytesToShort(Arrays.copyOfRange(serializedParentSpan, 16 + spiSpecificSpanSize + i * 2, 18 + spiSpecificSpanSize + i * 2), 0)));
                    }
                    break;
                }
            }
            assert (parentSpanType != null);
            if (parentSpanType.scope() != spanType.scope() && !includedScopes.contains((Object)spanType.scope())) {
                return new DeferredSpan(serializedParentSpan);
            }
            HashSet<Scope> mergedIncludedScopes = new HashSet<Scope>(includedScopes);
            mergedIncludedScopes.add(parentSpanType.scope());
            mergedIncludedScopes.remove((Object)spanType.scope());
            span = new SpanImpl((SpiSpecificSpan)((TracingSpi)this.getSpi()).create(spanType.spanName(), Arrays.copyOfRange(serializedParentSpan, 8, 8 + spiSpecificSpanSize)), spanType, mergedIncludedScopes);
        }
        catch (Exception e) {
            LT.warn(this.log, "Failed to create span from serialized value [serializedValue=" + Arrays.toString(serializedParentSpan) + "]");
            span = NoopSpan.INSTANCE;
        }
        return this.enrichWithLocalNodeParameters(span);
    }

    @Override
    @NotNull
    public Span create(@NotNull SpanType spanType, @Nullable Span parentSpan, @Nullable String lb) {
        if (this.noop) {
            return NoopSpan.INSTANCE;
        }
        if ((parentSpan == NoopSpan.INSTANCE || parentSpan == null) && this.tracingConfiguration.get(new TracingConfigurationCoordinates.Builder(spanType.scope()).withLabel(lb).build()).samplingRate() == 0.0) {
            return NoopSpan.INSTANCE;
        }
        return this.enrichWithLocalNodeParameters(this.generateSpan(parentSpan, spanType, lb));
    }

    @Override
    public byte[] serialize(@NotNull Span span) {
        if (this.noop) {
            return NoopTracing.NOOP_SERIALIZED_SPAN;
        }
        if (span == NoopSpan.INSTANCE) {
            return NoopTracing.NOOP_SERIALIZED_SPAN;
        }
        if (span instanceof DeferredSpan) {
            return ((DeferredSpan)span).serializedSpan();
        }
        byte[] spiSpecificSerializedSpan = ((TracingSpi)this.getSpi()).serialize(((SpanImpl)span).spiSpecificSpan());
        int serializedSpanLen = 16 + spiSpecificSerializedSpan.length + 2 * span.includedScopes().size();
        byte[] serializedSpanBytes = new byte[serializedSpanLen];
        serializedSpanBytes[1] = ((TracingSpi)this.getSpi()).type();
        serializedSpanBytes[2] = 0;
        serializedSpanBytes[3] = 0;
        System.arraycopy(GridClientByteUtils.intToBytes(spiSpecificSerializedSpan.length), 0, serializedSpanBytes, 4, 4);
        System.arraycopy(spiSpecificSerializedSpan, 0, serializedSpanBytes, 8, spiSpecificSerializedSpan.length);
        System.arraycopy(GridClientByteUtils.intToBytes(span.type().index()), 0, serializedSpanBytes, 8 + spiSpecificSerializedSpan.length, 4);
        assert (span.includedScopes() != null);
        System.arraycopy(GridClientByteUtils.intToBytes(span.includedScopes().size()), 0, serializedSpanBytes, 12 + spiSpecificSerializedSpan.length, 4);
        int includedScopesCnt = 0;
        if (!span.includedScopes().isEmpty()) {
            for (Scope includedScope : span.includedScopes()) {
                System.arraycopy(GridClientByteUtils.shortToBytes(includedScope.idx()), 0, serializedSpanBytes, 16 + spiSpecificSerializedSpan.length + 2 * includedScopesCnt++, 2);
            }
        }
        return serializedSpanBytes;
    }

    @NotNull
    private Span generateSpan(@Nullable Span parentSpan, @NotNull SpanType spanTypeToCreate, @Nullable String lb) {
        if (parentSpan instanceof DeferredSpan) {
            return this.create(spanTypeToCreate, ((DeferredSpan)parentSpan).serializedSpan());
        }
        if (parentSpan == NoopSpan.INSTANCE || parentSpan == null) {
            if (spanTypeToCreate.rootSpan()) {
                TracingConfigurationParameters tracingConfigurationParameters = this.tracingConfiguration.get(new TracingConfigurationCoordinates.Builder(spanTypeToCreate.scope()).withLabel(lb).build());
                return this.shouldSample(tracingConfigurationParameters.samplingRate()) ? new SpanImpl(((TracingSpi)this.getSpi()).create(spanTypeToCreate.spanName(), (SpiSpecificSpan)null), spanTypeToCreate, tracingConfigurationParameters.includedScopes()) : NoopSpan.INSTANCE;
            }
            return NoopSpan.INSTANCE;
        }
        if (parentSpan.isChainable(spanTypeToCreate.scope())) {
            HashSet<Scope> mergedIncludedScopes = new HashSet<Scope>(parentSpan.includedScopes());
            mergedIncludedScopes.add(parentSpan.type().scope());
            mergedIncludedScopes.remove((Object)spanTypeToCreate.scope());
            return new SpanImpl(((TracingSpi)this.getSpi()).create(spanTypeToCreate.spanName(), ((SpanImpl)parentSpan).spiSpecificSpan()), spanTypeToCreate, mergedIncludedScopes);
        }
        return NoopSpan.INSTANCE;
    }

    @Override
    public TraceableMessagesHandler messages() {
        if (this.noop) {
            return NOOP_TRACEABLE_MSG_HANDLER;
        }
        return this.msgHnd;
    }

    @Override
    @NotNull
    public TracingConfigurationManager configuration() {
        return this.tracingConfiguration;
    }

    private boolean shouldSample(double samlingRate) {
        if (samlingRate == 0.0) {
            return false;
        }
        return Math.random() <= samlingRate;
    }
}

