/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: graphpb.proto

package hugegraph_store_grpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// GraphStoreClient is the client API for GraphStore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GraphStoreClient interface {
	ScanPartition(ctx context.Context, opts ...grpc.CallOption) (GraphStore_ScanPartitionClient, error)
}

type graphStoreClient struct {
	cc grpc.ClientConnInterface
}

func NewGraphStoreClient(cc grpc.ClientConnInterface) GraphStoreClient {
	return &graphStoreClient{cc}
}

func (c *graphStoreClient) ScanPartition(ctx context.Context, opts ...grpc.CallOption) (GraphStore_ScanPartitionClient, error) {
	stream, err := c.cc.NewStream(ctx, &GraphStore_ServiceDesc.Streams[0], "/graph_pb.GraphStore/ScanPartition", opts...)
	if err != nil {
		return nil, err
	}
	x := &graphStoreScanPartitionClient{stream}
	return x, nil
}

type GraphStore_ScanPartitionClient interface {
	Send(*ScanPartitionRequest) error
	Recv() (*ScanResponse, error)
	grpc.ClientStream
}

type graphStoreScanPartitionClient struct {
	grpc.ClientStream
}

func (x *graphStoreScanPartitionClient) Send(m *ScanPartitionRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *graphStoreScanPartitionClient) Recv() (*ScanResponse, error) {
	m := new(ScanResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GraphStoreServer is the server API for GraphStore service.
// All implementations must embed UnimplementedGraphStoreServer
// for forward compatibility
type GraphStoreServer interface {
	ScanPartition(GraphStore_ScanPartitionServer) error
	mustEmbedUnimplementedGraphStoreServer()
}

// UnimplementedGraphStoreServer must be embedded to have forward compatible implementations.
type UnimplementedGraphStoreServer struct {
}

func (UnimplementedGraphStoreServer) ScanPartition(GraphStore_ScanPartitionServer) error {
	return status.Errorf(codes.Unimplemented, "method ScanPartition not implemented")
}
func (UnimplementedGraphStoreServer) mustEmbedUnimplementedGraphStoreServer() {}

// UnsafeGraphStoreServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GraphStoreServer will
// result in compilation errors.
type UnsafeGraphStoreServer interface {
	mustEmbedUnimplementedGraphStoreServer()
}

func RegisterGraphStoreServer(s grpc.ServiceRegistrar, srv GraphStoreServer) {
	s.RegisterService(&GraphStore_ServiceDesc, srv)
}

func _GraphStore_ScanPartition_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GraphStoreServer).ScanPartition(&graphStoreScanPartitionServer{stream})
}

type GraphStore_ScanPartitionServer interface {
	Send(*ScanResponse) error
	Recv() (*ScanPartitionRequest, error)
	grpc.ServerStream
}

type graphStoreScanPartitionServer struct {
	grpc.ServerStream
}

func (x *graphStoreScanPartitionServer) Send(m *ScanResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *graphStoreScanPartitionServer) Recv() (*ScanPartitionRequest, error) {
	m := new(ScanPartitionRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GraphStore_ServiceDesc is the grpc.ServiceDesc for GraphStore service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GraphStore_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "graph_pb.GraphStore",
	HandlerType: (*GraphStoreServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ScanPartition",
			Handler:       _GraphStore_ScanPartition_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "graphpb.proto",
}
