/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.testing.nio.HttpTestClient;
import org.apache.hc.core5.testing.nio.InternalClientProtocolNegotiationStarter;
import org.apache.hc.core5.testing.nio.LoggingExceptionCallback;
import org.apache.hc.core5.util.Args;

public class H2TestClient
extends HttpTestClient {
    private final List<RequestRouter.Entry<Supplier<AsyncPushConsumer>>> routeEntries = new ArrayList<RequestRouter.Entry<Supplier<AsyncPushConsumer>>>();
    private H2Config h2Config;
    private Http1Config http1Config;

    public H2TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext, SSLSessionInitializer sslSessionInitializer, SSLSessionVerifier sslSessionVerifier) throws IOException {
        super(ioReactorConfig, sslContext, sslSessionInitializer, sslSessionVerifier);
    }

    public H2TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, null, null, null);
    }

    public void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull(supplier, (String)"Push consumer supplier");
        this.routeEntries.add((RequestRouter.Entry<Supplier<AsyncPushConsumer>>)new RequestRouter.Entry(uriPattern, supplier));
    }

    public void configure(H2Config h2Config) {
        this.ensureNotRunning();
        this.h2Config = h2Config;
        this.http1Config = null;
    }

    public void configure(Http1Config http1Config) {
        this.ensureNotRunning();
        this.http1Config = http1Config;
        this.h2Config = null;
    }

    @Deprecated
    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        super.execute(handlerFactory);
    }

    @Deprecated
    public void start(HttpProcessor httpProcessor, H2Config h2Config) throws IOException {
        this.configure(h2Config);
        this.configure(httpProcessor);
        try {
            this.start();
        }
        catch (IOException | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Deprecated
    public void start(HttpProcessor httpProcessor, Http1Config http1Config) throws IOException {
        this.configure(http1Config);
        this.configure(httpProcessor);
        try {
            this.start();
        }
        catch (IOException | RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Deprecated
    public void start(H2Config h2Config) throws IOException {
        this.start(null, h2Config);
    }

    @Deprecated
    public void start(Http1Config http1Config) throws IOException {
        this.start(null, http1Config);
    }

    @Override
    public void start() throws Exception {
        if (this.http1Config != null) {
            this.start(new InternalClientProtocolNegotiationStarter(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.client(), (HandlerFactory<AsyncPushConsumer>)new DefaultAsyncPushConsumerFactory((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null)), HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, this.http1Config, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier, LoggingExceptionCallback.INSTANCE));
        } else {
            this.start(new InternalClientProtocolNegotiationStarter(this.httpProcessor != null ? this.httpProcessor : H2Processors.client(), (HandlerFactory<AsyncPushConsumer>)new DefaultAsyncPushConsumerFactory((HttpRequestMapper)RequestRouter.create((URIAuthority)RequestRouter.LOCAL_AUTHORITY, (UriPatternType)UriPatternType.URI_PATTERN, this.routeEntries, (BiFunction)RequestRouter.LOCAL_AUTHORITY_RESOLVER, null)), HttpVersionPolicy.FORCE_HTTP_2, this.h2Config, Http1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext, this.sslSessionInitializer, this.sslSessionVerifier, LoggingExceptionCallback.INSTANCE));
        }
    }
}

