/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.net.URI;
import java.util.Objects;
import org.apache.hc.client5.http.impl.cache.CacheKeyGenerator;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;

@Internal
public final class CacheSupport {
    public static final TimeValue MAX_AGE = TimeValue.ofSeconds((long)0x80000000L);

    public static URI getLocationURI(URI requestUri, MessageHeaders response, String headerName) {
        Header h = response.getFirstHeader(headerName);
        if (h == null) {
            return null;
        }
        URI locationUri = CacheKeyGenerator.normalize(h.getValue());
        if (locationUri == null) {
            return requestUri;
        }
        if (locationUri.isAbsolute()) {
            return locationUri;
        }
        return URIUtils.resolve((URI)requestUri, (URI)locationUri);
    }

    public static boolean isSameOrigin(URI requestURI, URI targetURI) {
        return targetURI.isAbsolute() && Objects.equals(requestURI.getAuthority(), targetURI.getAuthority());
    }

    public static long deltaSeconds(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return -1L;
        }
        try {
            long ageValue = Long.parseLong(s);
            if (ageValue < 0L) {
                ageValue = -1L;
            } else if (ageValue > Integer.MAX_VALUE) {
                ageValue = MAX_AGE.toSeconds();
            }
            return ageValue;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

