/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.flink.metrics.datadog.DSeries;
import org.apache.flink.metrics.datadog.DataCenter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadogHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatadogHttpClient.class);
    private static final String SERIES_URL_FORMAT = "https://app.datadoghq.%s/api/v1/series?api_key=%s";
    private static final String VALIDATE_URL_FORMAT = "https://app.datadoghq.%s/api/v1/validate?api_key=%s";
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json; charset=utf-8");
    private static final int TIMEOUT = 3;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String seriesUrl;
    private final String validateUrl;
    private final OkHttpClient client;
    private final String apiKey;
    private final String proxyHost;
    private final int proxyPort;

    public DatadogHttpClient(String dgApiKey, String dgProxyHost, int dgProxyPort, DataCenter dataCenter, boolean validateApiKey) {
        if (dgApiKey == null || dgApiKey.isEmpty()) {
            throw new IllegalArgumentException("Invalid API key:" + dgApiKey);
        }
        this.apiKey = dgApiKey;
        this.proxyHost = dgProxyHost;
        this.proxyPort = dgProxyPort;
        Proxy proxy = this.getProxy();
        this.client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).proxy(proxy).build();
        this.seriesUrl = String.format(SERIES_URL_FORMAT, dataCenter.getDomain(), this.apiKey);
        this.validateUrl = String.format(VALIDATE_URL_FORMAT, dataCenter.getDomain(), this.apiKey);
        if (validateApiKey) {
            this.validateApiKey();
        }
    }

    Proxy getProxy() {
        if (this.proxyHost == null) {
            return Proxy.NO_PROXY;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
    }

    private void validateApiKey() {
        Request r = new Request.Builder().url(this.validateUrl).get().build();
        try (Response response = this.client.newCall(r).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalArgumentException(String.format("API key: %s is invalid", this.apiKey));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed contacting Datadog to validate API key", e);
        }
    }

    public void send(DSeries request) throws Exception {
        String postBody = DatadogHttpClient.serialize(request);
        Request r = new Request.Builder().url(this.seriesUrl).post(RequestBody.create(MEDIA_TYPE, postBody)).build();
        this.client.newCall(r).enqueue(EmptyCallback.getEmptyCallback());
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        return MAPPER.writeValueAsString(obj);
    }

    public void close() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
    }

    protected static class EmptyCallback
    implements Callback {
        private static final EmptyCallback singleton = new EmptyCallback();

        protected EmptyCallback() {
        }

        public static Callback getEmptyCallback() {
            return singleton;
        }

        @Override
        public void onFailure(Call call, IOException e) {
            LOGGER.warn("Failed sending request to Datadog", (Throwable)e);
        }

        @Override
        public void onResponse(Call call, Response response) throws IOException {
            if (!response.isSuccessful()) {
                LOGGER.warn("Failed to send request to Datadog (response was {})", (Object)response);
            }
            response.close();
        }
    }
}

