/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.DefaultCatalogTable;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public interface CatalogTable
extends CatalogBaseTable {
    @PublicEvolving
    public static Builder newBuilder() {
        return new Builder();
    }

    public static CatalogTable fromProperties(Map<String, String> properties) {
        return CatalogPropertiesUtil.deserializeCatalogTable(properties);
    }

    @Override
    default public CatalogBaseTable.TableKind getTableKind() {
        return CatalogBaseTable.TableKind.TABLE;
    }

    public boolean isPartitioned();

    public List<String> getPartitionKeys();

    public CatalogTable copy(Map<String, String> var1);

    default public Optional<Long> getSnapshot() {
        return Optional.empty();
    }

    default public Optional<TableDistribution> getDistribution() {
        return Optional.empty();
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private Schema schema;
        @Nullable
        private String comment;
        private List<String> partitionKeys = Collections.emptyList();
        private Map<String, String> options = Collections.emptyMap();
        @Nullable
        private Long snapshot;
        @Nullable
        private TableDistribution distribution;

        private Builder() {
        }

        public Builder schema(Schema schema) {
            this.schema = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Builder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"Partition keys must not be null.");
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = (Map)Preconditions.checkNotNull(options, (String)"Options must not be null.");
            return this;
        }

        public Builder snapshot(@Nullable Long snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder distribution(@Nullable TableDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public CatalogTable build() {
            return new DefaultCatalogTable(this.schema, this.comment, this.partitionKeys, this.options, this.snapshot, this.distribution);
        }
    }
}

