/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.util.Preconditions;

public class Quantifier {
    private final EnumSet<QuantifierProperty> properties;
    private final ConsumingStrategy consumingStrategy;
    private ConsumingStrategy innerConsumingStrategy = ConsumingStrategy.SKIP_TILL_NEXT;

    private Quantifier(ConsumingStrategy consumingStrategy, QuantifierProperty first, QuantifierProperty ... rest) {
        this.properties = EnumSet.of(first, rest);
        this.consumingStrategy = consumingStrategy;
    }

    public static Quantifier one(ConsumingStrategy consumingStrategy) {
        return new Quantifier(consumingStrategy, QuantifierProperty.SINGLE, new QuantifierProperty[0]);
    }

    public static Quantifier looping(ConsumingStrategy consumingStrategy) {
        return new Quantifier(consumingStrategy, QuantifierProperty.LOOPING, new QuantifierProperty[0]);
    }

    public static Quantifier times(ConsumingStrategy consumingStrategy) {
        return new Quantifier(consumingStrategy, QuantifierProperty.TIMES, new QuantifierProperty[0]);
    }

    public boolean hasProperty(QuantifierProperty property) {
        return this.properties.contains((Object)property);
    }

    public ConsumingStrategy getInnerConsumingStrategy() {
        return this.innerConsumingStrategy;
    }

    public ConsumingStrategy getConsumingStrategy() {
        return this.consumingStrategy;
    }

    private static void checkPattern(boolean condition, Object errorMessage) {
        if (!condition) {
            throw new MalformedPatternException(String.valueOf(errorMessage));
        }
    }

    public void combinations() {
        Quantifier.checkPattern(!this.hasProperty(QuantifierProperty.SINGLE), "Combinations not applicable to " + this + "!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.STRICT, "You can apply either combinations or consecutive, not both!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.SKIP_TILL_ANY, "Combinations already applied!");
        this.innerConsumingStrategy = ConsumingStrategy.SKIP_TILL_ANY;
    }

    public void consecutive() {
        Quantifier.checkPattern(this.hasProperty(QuantifierProperty.LOOPING) || this.hasProperty(QuantifierProperty.TIMES), "Consecutive not applicable to " + this + "!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.SKIP_TILL_ANY, "You can apply either combinations or consecutive, not both!");
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.STRICT, "Consecutive already applied!");
        this.innerConsumingStrategy = ConsumingStrategy.STRICT;
    }

    public void optional() {
        Quantifier.checkPattern(!this.hasProperty(QuantifierProperty.OPTIONAL), "Optional already applied!");
        Quantifier.checkPattern(this.consumingStrategy != ConsumingStrategy.NOT_NEXT && this.consumingStrategy != ConsumingStrategy.NOT_FOLLOW, "NOT pattern cannot be optional");
        this.properties.add(QuantifierProperty.OPTIONAL);
    }

    public void greedy() {
        Quantifier.checkPattern(this.innerConsumingStrategy != ConsumingStrategy.SKIP_TILL_ANY, "Option not applicable to FollowedByAny pattern");
        Quantifier.checkPattern(!this.hasProperty(QuantifierProperty.SINGLE), "Option not applicable to singleton quantifier");
        this.properties.add(QuantifierProperty.GREEDY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quantifier that = (Quantifier)o;
        return Objects.equals(this.properties, that.properties) && this.consumingStrategy == that.consumingStrategy && this.innerConsumingStrategy == that.innerConsumingStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.properties, this.consumingStrategy, this.innerConsumingStrategy});
    }

    public String toString() {
        return "Quantifier{properties=" + this.properties + ", consumingStrategy=" + this.consumingStrategy + ", innerConsumingStrategy=" + this.innerConsumingStrategy + "}";
    }

    public static class Times {
        private final int from;
        private final int to;
        @Nullable
        private final Duration windowTime;

        private Times(int from, int to, @Nullable Duration windowTime) {
            Preconditions.checkArgument((from > 0 ? 1 : 0) != 0, (Object)"The from should be a positive number greater than 0.");
            Preconditions.checkArgument((to >= from ? 1 : 0) != 0, (Object)("The to should be a number greater than or equal to from: " + from + "."));
            this.from = from;
            this.to = to;
            this.windowTime = windowTime;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public Optional<Duration> getWindowSize() {
            return Optional.ofNullable(this.windowTime);
        }

        public static Times of(int from, int to, @Nullable Duration windowTime) {
            return new Times(from, to, windowTime);
        }

        public static Times of(int times, @Nullable Duration windowTime) {
            return new Times(times, times, windowTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Times times = (Times)o;
            return this.from == times.from && this.to == times.to && (this.windowTime == null && times.windowTime == null || this.windowTime != null && times.windowTime != null && this.windowTime.toMillis() == times.windowTime.toMillis());
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to, this.windowTime);
        }
    }

    public static enum ConsumingStrategy {
        STRICT,
        SKIP_TILL_NEXT,
        SKIP_TILL_ANY,
        NOT_FOLLOW,
        NOT_NEXT;

    }

    public static enum QuantifierProperty {
        SINGLE,
        LOOPING,
        TIMES,
        OPTIONAL,
        GREEDY;

    }
}

