/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapUnionTest {
    @Test
    public void checkExactUnionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
    }

    @Test
    public void checkEstUnionNoOverlap() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
    }

    @Test
    public void checkExactUnionWithOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate() / 2.0), (double)0.0);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
    }

    @Test
    public void checkHeapifyExact() {
        int i;
        int lgK = 9;
        int k = 512;
        int u = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((double)512.0, (double)(usk1.getEstimate() + usk2.getEstimate()), (double)0.0);
        Union union = SetOperation.builder().setNominalEntries(512).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 512.0, 0.0);
        Union union2 = (Union)SetOperation.heapify((Memory)Memory.wrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 512.0, 0.0);
    }

    @Test
    public void checkHeapifyEstNoOverlap() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = (Union)SetOperation.heapify((Memory)Memory.wrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
    }

    @Test
    public void checkHeapifyEstNoOverlapOrderedIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        CompactSketch cosk2 = usk2.compact(true, null);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)cosk2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = (Union)SetOperation.heapify((Memory)Memory.wrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkWrapEstNoOverlapOrderedDirectIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory cskMem2 = WritableMemory.writableWrap((byte[])new byte[usk2.getCompactBytes()]);
        CompactSketch cosk2 = usk2.compact(true, cskMem2);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)cosk2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = (Union)SetOperation.heapify((Memory)Memory.wrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkHeapifyEstNoOverlapOrderedMemIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory cskMem2 = WritableMemory.writableWrap((byte[])new byte[usk2.getCompactBytes()]);
        usk2.compact(true, cskMem2);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)usk1);
        union.union((Memory)cskMem2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = (Union)SetOperation.heapify((Memory)Memory.wrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkHeapifyEstNoOverlapUnorderedMemIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u = 16384;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 16384; ++i) {
            usk2.update((long)i);
        }
        WritableMemory cskMem2 = WritableMemory.writableWrap((byte[])new byte[usk2.getCompactBytes()]);
        usk2.compact(false, cskMem2);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)usk1);
        union.union((Memory)cskMem2);
        UpdateSketch emptySketch = UpdateSketch.builder().setNominalEntries(4096).build();
        union.union((Sketch)emptySketch);
        emptySketch = null;
        union.union((Sketch)emptySketch);
        HeapUnionTest.testAllCompactForms(union, 16384.0, 0.05);
        Union union2 = (Union)SetOperation.heapify((Memory)Memory.wrap((byte[])union.toByteArray()));
        HeapUnionTest.testAllCompactForms(union2, 16384.0, 0.05);
        union2.reset();
        Assert.assertEquals((double)union2.getResult(true, null).getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkMultiUnion() {
        int i;
        int lgK = 13;
        int k = 8192;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(8192).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(8192).build();
        UpdateSketch usk3 = UpdateSketch.builder().setNominalEntries(8192).build();
        UpdateSketch usk4 = UpdateSketch.builder().setNominalEntries(8192).build();
        int v = 0;
        int u = 1000000;
        for (i = 0; i < u; ++i) {
            usk1.update((long)(i + v));
        }
        v += u;
        u = 26797;
        for (i = 0; i < u; ++i) {
            usk2.update((long)(i + v));
        }
        v += u;
        for (i = 0; i < u; ++i) {
            usk3.update((long)(i + v));
        }
        v += u;
        for (i = 0; i < u; ++i) {
            usk4.update((long)(i + v));
        }
        v += u;
        Union union = SetOperation.builder().setNominalEntries(8192).buildUnion();
        union.union((Sketch)usk1);
        union.union((Sketch)usk2);
        union.union((Sketch)usk3);
        union.union((Sketch)usk4);
        CompactSketch csk = union.getResult(true, null);
        double est = csk.getEstimate();
        Assert.assertEquals((double)est, (double)v, (double)(0.01 * (double)v));
    }

    @Test
    public void checkDirectMemoryIn() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        WritableMemory skMem1 = WritableMemory.writableWrap((byte[])usk1.compact(false, null).toByteArray());
        WritableMemory skMem2 = WritableMemory.writableWrap((byte[])usk2.compact(true, null).toByteArray());
        CompactSketch csk1 = (CompactSketch)Sketch.wrap((Memory)skMem1);
        CompactSketch csk2 = (CompactSketch)Sketch.wrap((Memory)skMem2);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Sketch)csk1);
        union.union((Sketch)csk2);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkSerVer1Handling() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        Memory v1mem1 = BackwardConversions.convertSerVer3toSerVer1(usk1.compact(true, null));
        Memory v1mem2 = BackwardConversions.convertSerVer3toSerVer1(usk2.compact(true, null));
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union(v1mem1);
        union.union(v1mem2);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkSerVer2Handling() {
        int i;
        int lgK = 12;
        int k = 4096;
        int u1 = 8192;
        int u2 = 1024;
        int totU = 9216;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        for (i = 8192; i < 9216; ++i) {
            usk2.update((long)i);
        }
        Memory v2mem1 = BackwardConversions.convertSerVer3toSerVer2(usk1.compact(true, null), 9001L);
        Memory v2mem2 = BackwardConversions.convertSerVer3toSerVer2(usk2.compact(true, null), 9001L);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union(v2mem1);
        union.union(v2mem2);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)9216.0, (double)204.8);
    }

    @Test
    public void checkUpdateMemorySpecialCases() {
        int lgK = 12;
        int k = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        CompactSketch usk1c = usk1.compact(true, null);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])usk1c.toByteArray());
        Memory v1mem1 = BackwardConversions.convertSerVer3toSerVer1(usk1.compact(true, null));
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union(v1mem1);
        CompactSketch cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
        Memory v2mem1 = BackwardConversions.convertSerVer3toSerVer2(usk1.compact(true, null), 9001L);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union(v2mem1);
        cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Memory)v3mem1);
        cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
        union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        v3mem1 = null;
        union.union((Memory)v3mem1);
        cOut = union.getResult(true, null);
        Assert.assertEquals((double)cOut.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkUpdateMemorySpecialCases2() {
        int lgK = 12;
        int k = 4096;
        int u = 8192;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        for (int i = 0; i < 8192; ++i) {
            usk1.update((long)i);
        }
        CompactSketch usk1c = usk1.compact(true, null);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])usk1c.toByteArray());
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Memory)v3mem1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemBadSerVer() {
        int lgK = 12;
        int k = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(4096).build();
        usk1.update(1L);
        usk1.update(2L);
        CompactSketch usk1c = usk1.compact(true, null);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])usk1c.toByteArray());
        v3mem1.putByte(1L, (byte)0);
        Union union = SetOperation.builder().setNominalEntries(4096).buildUnion();
        union.union((Memory)v3mem1);
    }

    @Test
    public void checkEmptySerVer2and3() {
        UpdateSketch usk1 = UpdateSketch.builder().build();
        CompactSketch usk1c = usk1.compact(true, null);
        byte[] skArr = usk1c.toByteArray();
        byte[] skArr2 = Arrays.copyOf(skArr, skArr.length * 2);
        WritableMemory v3mem1 = WritableMemory.writableWrap((byte[])skArr2);
        Union union = SetOperation.builder().buildUnion();
        union.union((Memory)v3mem1);
        Memory v2mem1 = BackwardConversions.convertSerVer3toSerVer2(usk1c, 9001L);
        WritableMemory v2mem2 = WritableMemory.writableWrap((byte[])new byte[16]);
        v2mem1.copyTo(0L, v2mem2, 0L, 8L);
        union = SetOperation.builder().buildUnion();
        union.union((Memory)v2mem2);
    }

    @Test
    public void checkGetResult() {
        int k = 1024;
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        Union union = Sketches.setOperationBuilder().setNominalEntries(1024).buildUnion();
        union.union((Sketch)sk);
        CompactSketch csk = union.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkTrimToK() {
        int hiK = 1024;
        int loK = 512;
        UpdateSketch hiSk = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 3749; ++i) {
            hiSk.update((long)i);
        }
        UpdateSketch loSk = Sketches.updateSketchBuilder().setNominalEntries(512).build();
        for (int i = 0; i < 1783; ++i) {
            loSk.update((long)(i + 10000));
        }
        Union union = Sketches.setOperationBuilder().setNominalEntries(1024).buildUnion();
        CompactSketch csk = union.union((Sketch)hiSk, (Sketch)loSk);
        HeapUnionTest.println(csk.toString());
        Assert.assertEquals((int)csk.getRetainedEntries(), (int)1024);
    }

    @Test
    public void checkPrimitiveUpdates() {
        int k = 32;
        Union union = Sketches.setOperationBuilder().setNominalEntries(32).buildUnion();
        union.update(1L);
        union.update(1.5);
        union.update(0.0);
        union.update(-0.0);
        String s = null;
        union.update(s);
        s = "";
        union.update(s);
        s = "String";
        union.update(s);
        byte[] byteArr = null;
        union.update(byteArr);
        byteArr = new byte[]{};
        union.update(byteArr);
        union.update(ByteBuffer.wrap(byteArr));
        byteArr = "Byte Array".getBytes(StandardCharsets.UTF_8);
        union.update(byteArr);
        union.update(ByteBuffer.wrap(byteArr));
        union.update(ByteBuffer.wrap(byteArr, 0, 4));
        char[] charArr = null;
        union.update(charArr);
        charArr = new char[]{};
        union.update(charArr);
        charArr = "String".toCharArray();
        union.update(charArr);
        int[] intArr = null;
        union.update(intArr);
        intArr = new int[]{};
        union.update(intArr);
        int[] intArr2 = new int[]{1, 2, 3, 4, 5};
        union.update(intArr2);
        long[] longArr = null;
        union.update(longArr);
        longArr = new long[]{};
        union.update(longArr);
        long[] longArr2 = new long[]{6L, 7L, 8L, 9L};
        union.update(longArr2);
        CompactSketch comp = union.getResult();
        double est = comp.getEstimate();
        boolean empty = comp.isEmpty();
        Assert.assertEquals((double)est, (double)9.0, (double)0.0);
        Assert.assertFalse((boolean)empty);
    }

    public static void testAllCompactForms(Union union, double expected, double toll) {
        double compEst1 = union.getResult(false, null).getEstimate();
        Assert.assertEquals((double)compEst1, (double)expected, (double)(toll * expected));
        CompactSketch comp2 = union.getResult(true, null);
        double compEst2 = comp2.getEstimate();
        Assert.assertEquals((double)compEst2, (double)compEst1, (double)0.0);
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[comp2.getCurrentBytes()]);
        compEst2 = union.getResult(false, mem).getEstimate();
        Assert.assertEquals((double)compEst2, (double)compEst1, (double)0.0);
        compEst2 = union.getResult(true, mem).getEstimate();
        Assert.assertEquals((double)compEst2, (double)compEst1, (double)0.0);
    }

    @Test
    public void checkGetFamily() {
        SetOperation setOp = new SetOperationBuilder().build(Family.UNION);
        Assert.assertEquals((Object)setOp.getFamily(), (Object)Family.UNION);
    }

    @Test
    public void printlnTest() {
        HeapUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

