/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.binding.Utility;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.ValidationContext;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.util.InsertionOrderedMap;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.LazyList;
import org.jibx.util.UniqueNameSet;

public class BindingOrganizer {
    private static final Logger s_logger = Logger.getLogger((String)BindingOrganizer.class.getName());
    private static final String BASE_PREFIX = "ns";
    private final boolean m_forceClasses;
    private final boolean m_trackSource;
    private final boolean m_addConstructors;
    private final boolean m_inBinding;
    private final boolean m_outBinding;
    private final boolean m_trimWhitespace;
    private final Map m_uriPrefixFixed;
    private final Map m_uriPrefixDefaults;
    private final List m_keyObjects;
    private final Map m_objectBindings;
    private final Map m_referenceUriBinding;
    private final Set m_nsRootUris;
    private final List m_formats;
    private boolean m_nonamespaceUsed;
    private boolean m_finished;

    public BindingOrganizer(boolean force, boolean track, boolean addcon, boolean in, boolean out, boolean trim) {
        s_logger.debug((Object)("Created binding organizer with force=" + force + ", track=" + track + ", addcon=" + addcon + ", in=" + in + ", out=" + out));
        this.m_uriPrefixFixed = new HashMap();
        this.m_forceClasses = force;
        this.m_trackSource = track;
        this.m_addConstructors = addcon;
        this.m_inBinding = in;
        this.m_outBinding = out;
        this.m_trimWhitespace = trim;
        this.m_uriPrefixDefaults = new HashMap();
        this.m_keyObjects = new ArrayList();
        this.m_objectBindings = new HashMap();
        this.m_referenceUriBinding = new InsertionOrderedMap();
        this.m_nsRootUris = new InsertionOrderedSet();
        this.m_formats = new LazyList();
    }

    public BindingHolder addBinding(Object obj, String uri, String prefix, boolean dflt) {
        if (uri == null) {
            if (!dflt) {
                s_logger.error((Object)"No-namespace namespace must be element default");
                throw new IllegalArgumentException("Internal error - no-namespace namespace must be element default");
            }
            if (prefix != null && prefix.length() > 0) {
                s_logger.error((Object)("Cannot use prefix ('" + prefix + "' requested) for no-namespace namespace"));
                throw new IllegalArgumentException("Configuration error - cannot use prefix ('" + prefix + "' requested) for no-namespace namespace");
            }
            prefix = "";
        }
        BindingHolder hold = new BindingHolder(uri, dflt, this);
        this.m_keyObjects.add(obj);
        this.m_objectBindings.put(obj, hold);
        if (prefix != null) {
            String prior = (String)this.m_uriPrefixFixed.get(uri);
            if (prior == null) {
                this.m_uriPrefixFixed.put(uri, prefix);
            } else if (!prior.equals(prefix)) {
                s_logger.error((Object)("Conflicting prefixes ('" + prefix + "' and '" + prior + "') for namespace " + uri));
                throw new IllegalArgumentException("Configuration error - conflicting prefixes ('" + prefix + "' and '" + prior + "') for namespace " + uri);
            }
            hold.setPrefix(prefix);
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Added binding associatiated with " + obj + " with namespace " + uri + " and prefix " + prefix + " (dflt=" + dflt + ')'));
        }
        BindingElement binding = hold.getBinding();
        binding.setForceClasses(this.m_forceClasses);
        binding.setTrackSource(this.m_trackSource);
        binding.setAddConstructors(this.m_addConstructors);
        binding.setInBinding(this.m_inBinding);
        binding.setOutBinding(this.m_outBinding);
        binding.setTrimWhitespace(this.m_trimWhitespace);
        return hold;
    }

    public BindingHolder getBinding(Object obj) {
        return (BindingHolder)this.m_objectBindings.get(obj);
    }

    public BindingHolder getRequiredBinding(Object obj) {
        BindingHolder hold = (BindingHolder)this.m_objectBindings.get(obj);
        if (hold == null) {
            s_logger.error((Object)("Missing required binding for object " + obj));
            throw new IllegalStateException("Internal error - binding not defined for " + obj);
        }
        return hold;
    }

    public void addBindingObject(Object obj, BindingHolder holder) {
        this.m_objectBindings.put(obj, holder);
    }

    public void addDefaultPrefix(String uri, String pref) {
        if (!this.m_uriPrefixDefaults.containsKey(uri)) {
            this.m_uriPrefixDefaults.put(uri, pref);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Added default prefix '" + pref + "' for namespace " + uri));
            }
        }
    }

    public void forceBindingPrefix(String prefix, BindingHolder holder) {
        holder.setPrefix(prefix);
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private void checkModifiable() {
        if (this.m_finished) {
            throw new IllegalStateException("Internal error - attempt to modify bindings after finalized");
        }
    }

    void addNamespaceUsage(BindingHolder hold, String uri) {
        this.checkModifiable();
        if (uri == null) {
            this.m_nonamespaceUsed = true;
        } else if (!("http://www.w3.org/XML/1998/namespace".equals(uri) || uri.equals(hold.getNamespace()) || this.m_nsRootUris.contains(uri))) {
            BindingHolder refhold = (BindingHolder)this.m_referenceUriBinding.get(uri);
            if (refhold == null) {
                this.m_referenceUriBinding.put(uri, hold);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Recorded first usage of namespace " + uri + " from binding with namespace " + hold.getNamespace()));
                }
            } else if (refhold != hold) {
                this.m_nsRootUris.add(uri);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Added namespace definition for " + uri + " to root binding after reference from binding with namespace " + hold.getNamespace()));
                }
            }
        }
    }

    public void addTypeNameReference(BindingHolder hold, String uri, Object obj) {
        this.checkModifiable();
        if (uri != null && hold.getReferencedNamespaces().add(uri)) {
            BindingHolder tohold = this.getRequiredBinding(obj);
            if (hold != tohold) {
                tohold.forcePullUpNamespaces();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Added reference to binding with namespace " + uri + " from binding with namespace " + hold.getNamespace()));
            }
        }
    }

    public void addFormat(FormatElement format) {
        this.checkModifiable();
        this.m_formats.add(format);
    }

    public Iterator iterateBindings() {
        return this.m_objectBindings.values().iterator();
    }

    public void addRootUris(Collection uris) {
        this.m_nsRootUris.addAll(uris);
    }

    public List getKeys() {
        return this.m_keyObjects;
    }

    private static boolean isAsciiAlpha(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z';
    }

    private static boolean isAsciiNum(char chr) {
        return chr >= '0' && chr <= '9';
    }

    private static boolean isAsciiAlphaNum(char chr) {
        return BindingOrganizer.isAsciiAlpha(chr) || BindingOrganizer.isAsciiNum(chr);
    }

    private void generatePrefix(String uri, UniqueNameSet prefset, Map uridfltprefs) {
        if (uri != null && !uridfltprefs.containsKey(uri)) {
            String prefix = prefset.add(BASE_PREFIX);
            uridfltprefs.put(uri, prefix);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Assigned generated prefix '" + prefix + "' for namespace " + uri));
            }
        }
    }

    private Map buildDefaultPrefixes(UniqueNameSet prefset, Map nsdfltpref) {
        Iterator<Object> iter;
        String prefix;
        if (this.m_nonamespaceUsed) {
            prefset.add("");
            nsdfltpref.put(null, "");
        }
        if (this.m_nsRootUris.size() > 0) {
            if (this.m_uriPrefixFixed.size() > 0) {
                s_logger.debug((Object)"Setting prefixes for namespaces used at root level based on prefixes specified for bindings...");
                for (String uri : this.m_nsRootUris) {
                    if (nsdfltpref.containsKey(uri)) continue;
                    prefix = (String)this.m_uriPrefixFixed.get(uri);
                    if (prefset.contains(prefix)) {
                        s_logger.debug((Object)("Conflicting use of prefix '" + prefix + "' for multiple namespaces used in root binding"));
                        throw new IllegalStateException("Conflicting use of prefix '" + prefix + "' for multiple namespaces used in root binding - change one of the uses of this prefix");
                    }
                    if (prefix == null) continue;
                    nsdfltpref.put(uri, prefix);
                    prefset.add(prefix);
                    if (!s_logger.isDebugEnabled()) continue;
                    s_logger.debug((Object)("Assigned prefix '" + prefix + "' for namespace " + uri));
                }
            }
            if (this.m_uriPrefixDefaults.size() > 0 && nsdfltpref.size() < this.m_nsRootUris.size()) {
                s_logger.debug((Object)"Setting prefixes for namespaces used at root level based on configured default prefixes...");
                for (String uri : this.m_nsRootUris) {
                    if (nsdfltpref.containsKey(uri) || prefset.contains(prefix = (String)this.m_uriPrefixDefaults.get(uri))) continue;
                    nsdfltpref.put(uri, prefix);
                    prefset.add(prefix);
                    if (!s_logger.isDebugEnabled()) continue;
                    s_logger.debug((Object)("Assigned prefix '" + prefix + "' for namespace " + uri));
                }
            }
            if (!prefset.contains(BASE_PREFIX)) {
                prefset.add(BASE_PREFIX);
            }
            if (nsdfltpref.size() < this.m_nsRootUris.size()) {
                s_logger.debug((Object)"Generating prefixes for remaining namespaces used at root level...");
                iter = this.m_nsRootUris.iterator();
                while (iter.hasNext()) {
                    this.generatePrefix((String)iter.next(), prefset, nsdfltpref);
                }
            }
        } else {
            prefset.add(BASE_PREFIX);
        }
        if (this.m_uriPrefixFixed.size() > 0) {
            s_logger.debug((Object)"Setting namespace prefixes based on prefixes specified for bindings...");
            for (String uri : this.m_uriPrefixFixed.keySet()) {
                if (nsdfltpref.containsKey(uri) || prefset.contains(prefix = (String)this.m_uriPrefixFixed.get(uri))) continue;
                nsdfltpref.put(uri, prefix);
                prefset.add(prefix);
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)("Assigned prefix '" + prefix + "' for namespace " + uri));
            }
        }
        if (this.m_uriPrefixDefaults.size() > 0) {
            s_logger.debug((Object)"Setting namespace prefixes based on configured defaults...");
            for (String uri : this.m_uriPrefixDefaults.keySet()) {
                if (nsdfltpref.containsKey(uri) || prefset.contains(prefix = (String)this.m_uriPrefixDefaults.get(uri))) continue;
                nsdfltpref.put(uri, prefix);
                prefset.add(prefix);
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)("Assigned prefix '" + prefix + "' for namespace " + uri));
            }
        }
        s_logger.debug((Object)"Finish prefix assignment for all namespaces referenced or used...");
        iter = this.m_keyObjects.iterator();
        while (iter.hasNext()) {
            BindingHolder holder = (BindingHolder)this.m_objectBindings.get(iter.next());
            String uri = holder.getNamespace();
            if (holder.isBindingNamespaceUsed() && !holder.isNamespaceElementDefault()) {
                this.generatePrefix(uri, prefset, nsdfltpref);
            } else if (!nsdfltpref.containsKey(uri)) {
                nsdfltpref.put(uri, "");
            }
            Iterator jter = holder.getReferencedNamespaces().iterator();
            while (jter.hasNext()) {
                this.generatePrefix((String)jter.next(), prefset, nsdfltpref);
            }
            jter = holder.getUsedNamespaces().iterator();
            while (jter.hasNext()) {
                this.generatePrefix((String)jter.next(), prefset, nsdfltpref);
            }
        }
        s_logger.debug((Object)"Generate prefixes for namespaces used as default...");
        HashMap<String, String> frcedprfx = new HashMap<String, String>();
        for (String uri : nsdfltpref.keySet()) {
            String prefix2 = (String)nsdfltpref.get(uri);
            if (prefix2 == null || prefix2.length() == 0) {
                prefix2 = prefset.add(BASE_PREFIX);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Assigned generated prefix '" + prefix2 + "' for namespace " + uri));
                }
            }
            frcedprfx.put(uri, prefix2);
        }
        return frcedprfx;
    }

    public BindingHolder configureFiles(String rootname, String trgtpack, List pregens) {
        BindingElement rootbind;
        BindingHolder hold;
        ArrayList objs;
        this.checkModifiable();
        if (this.m_objectBindings.size() > 1) {
            objs = new ArrayList();
            for (Object obj : this.m_keyObjects) {
                hold = (BindingHolder)this.m_objectBindings.get(obj);
                if (hold.getMappingCount() > 0) {
                    objs.add(obj);
                    continue;
                }
                this.m_objectBindings.put(obj, null);
                if (!s_logger.isDebugEnabled()) continue;
                s_logger.debug((Object)("Eliminated empty binding associated with " + obj));
            }
            this.m_keyObjects.clear();
            this.m_keyObjects.addAll(objs);
        } else {
            objs = this.m_keyObjects;
        }
        for (Object obj : objs) {
            hold = (BindingHolder)this.m_objectBindings.get(obj);
            String uri = hold.getNamespace();
            if (uri != null && !"http://www.w3.org/XML/1998/namespace".equals(uri) && !this.m_nsRootUris.contains(uri) && this.m_referenceUriBinding.get(uri) != null) {
                this.m_nsRootUris.add(uri);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Added namespace " + uri + " to set defined in root binding based on reference and usage"));
                }
            }
            if (!hold.isPullUpNamespaces()) continue;
            for (String useduri : hold.getUsedNamespaces()) {
                if (useduri == null || "http://www.w3.org/XML/1998/namespace".equals(useduri)) continue;
                this.m_nsRootUris.add(useduri);
            }
            if (!s_logger.isDebugEnabled()) continue;
            s_logger.debug((Object)("Added all namespaces used in binding associated with " + obj + " to set defined in root binding based on abstract mapping usage"));
        }
        UniqueNameSet prefset = new UniqueNameSet();
        HashMap uridfltpref = new HashMap();
        Map urifrcdpref = this.buildDefaultPrefixes(prefset, uridfltpref);
        BindingHolder roothold = null;
        ArrayList<IncludeElement> includes = new ArrayList<IncludeElement>(pregens);
        if (objs.size() == 1) {
            roothold = (BindingHolder)this.m_objectBindings.get(objs.get(0));
            rootbind = roothold.getBinding();
        } else {
            String uri;
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                BindingHolder hold2 = (BindingHolder)this.m_objectBindings.get(iter.next());
                if (!rootname.equals(hold2.getFileName())) continue;
                roothold = hold2;
                break;
            }
            if (roothold == null && (roothold = this.getBinding(null)) == null) {
                roothold = this.addBinding(null, null, "", true);
            }
            rootbind = roothold.getBinding();
            if (roothold.isBindingNamespaceUsed() && (uri = roothold.getNamespace()) != null && !"http://www.w3.org/XML/1998/namespace".equals(uri)) {
                this.m_nsRootUris.add(uri);
            }
            UniqueNameSet nameset = new UniqueNameSet();
            nameset.add(rootname);
            Iterator iter2 = objs.iterator();
            while (iter2.hasNext()) {
                BindingHolder holder = (BindingHolder)this.m_objectBindings.get(iter2.next());
                if (holder == roothold) continue;
                if (holder.getFileName() == null) {
                    String bindname;
                    String raw = holder.getNamespace();
                    if (raw == null) {
                        bindname = "nonamespaceBinding";
                    } else {
                        int split = (raw = raw.replace('\\', '/')).indexOf("://");
                        if (split >= 0) {
                            raw = raw.substring(split + 3);
                        }
                        while (raw.endsWith("/")) {
                            raw = raw.substring(0, raw.length() - 1);
                        }
                        split = raw.indexOf(47);
                        if (split > 0 && raw.substring(0, split).indexOf(46) > 0) {
                            raw = raw.substring(split + 1);
                        }
                        StringBuffer buff = new StringBuffer();
                        int index = 0;
                        char chr = raw.charAt(0);
                        if (BindingOrganizer.isAsciiAlpha(chr)) {
                            buff.append(chr);
                            index = 1;
                        } else {
                            buff.append('_');
                        }
                        boolean toupper = false;
                        while (index < raw.length()) {
                            if (BindingOrganizer.isAsciiAlphaNum(chr = raw.charAt(index++))) {
                                if (toupper) {
                                    chr = Character.toUpperCase(chr);
                                    toupper = false;
                                }
                                buff.append(chr);
                                continue;
                            }
                            if (chr == '.') {
                                toupper = true;
                                continue;
                            }
                            if (chr != ':' && chr != '/') continue;
                            buff.append('_');
                        }
                        buff.append("Binding");
                        bindname = buff.toString();
                    }
                    holder.setFileName(nameset.add(bindname) + ".xml");
                }
                holder.finish(Collections.EMPTY_LIST, Collections.EMPTY_LIST, this.m_nsRootUris, uridfltpref, urifrcdpref);
                IncludeElement include = new IncludeElement();
                include.setIncludePath(holder.getFileName());
                includes.add(include);
            }
        }
        for (String uri : this.m_nsRootUris) {
            if (uri.equals(roothold.getNamespace())) continue;
            roothold.getUsedNamespaces().add(uri);
        }
        for (FormatElement format : this.m_formats) {
            String uri;
            QName qname = format.getQName();
            if (qname == null || (uri = qname.getUri()) == null) continue;
            roothold.getReferencedNamespaces().add(uri);
        }
        roothold.finish(this.m_formats, includes, Collections.EMPTY_SET, uridfltpref, urifrcdpref);
        roothold.setFileName(rootname);
        rootbind.setName(Utility.bindingFromFileName(rootname));
        this.m_finished = true;
        rootbind.setTargetPackage(trgtpack);
        return roothold;
    }

    public boolean validateBindings(BindingHolder root, File dir, ValidationContext vctx) throws IOException {
        BindingElement binding = root.getBinding();
        binding.setBaseUrl(dir.toURI().toURL());
        List keys = this.getKeys();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String path;
            BindingHolder holder = (BindingHolder)this.m_objectBindings.get(iter.next());
            if (holder == null || holder == root || !binding.addIncludePath(path = new File(dir, holder.getFileName()).toURI().toURL().toExternalForm(), false)) continue;
            binding.addIncludeBinding(path, holder.getBinding());
        }
        vctx.setBindingRoot(binding);
        binding.runValidation(vctx.isLookupSupported(), vctx);
        return vctx.getErrorCount() == 0 && vctx.getFatalCount() == 0;
    }

    public void writeBindings(File dir) throws JiBXException, IOException {
        IBindingFactory fact = BindingDirectory.getFactory((String)"normal", BindingElement.class);
        IMarshallingContext ictx = fact.createMarshallingContext();
        ictx.setIndent(2);
        List keys = this.getKeys();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            BindingHolder holder = (BindingHolder)this.m_objectBindings.get(iter.next());
            if (holder == null) continue;
            File file = new File(dir, holder.getFileName());
            ictx.setOutput((OutputStream)new FileOutputStream(file), null);
            ((IMarshallable)holder.getBinding()).marshal(ictx);
            ictx.getXmlWriter().flush();
        }
    }
}

