/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import org.apache.camel.Predicate;
import org.apache.camel.model.OnWhenDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="interceptSendToEndpoint")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptSendToEndpointDefinition
extends OutputDefinition<InterceptSendToEndpointDefinition> {
    @XmlAttribute(required=true)
    private String uri;
    @XmlAttribute
    private String skipSendToOriginalEndpoint;
    @XmlAttribute
    @Metadata(label="advanced")
    private String afterUri;
    @Metadata(description="To use an expression to only trigger intercepting sending to an endpoint in specific situations")
    @XmlElement
    @AsPredicate
    private OnWhenDefinition onWhen;

    public InterceptSendToEndpointDefinition() {
    }

    protected InterceptSendToEndpointDefinition(InterceptSendToEndpointDefinition source) {
        super(source);
        this.uri = source.uri;
        this.skipSendToOriginalEndpoint = source.skipSendToOriginalEndpoint;
        this.afterUri = source.afterUri;
        this.onWhen = source.onWhen != null ? source.onWhen.copyDefinition() : null;
    }

    public InterceptSendToEndpointDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public InterceptSendToEndpointDefinition copyDefinition() {
        return new InterceptSendToEndpointDefinition(this);
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public OnWhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(OnWhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    @Override
    public String toString() {
        return "InterceptSendToEndpoint[" + this.uri + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public String getShortName() {
        return "interceptSendToEndpoint";
    }

    @Override
    public String getLabel() {
        return "interceptSendToEndpoint[" + this.uri + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Deprecated
    public InterceptSendToEndpointDefinition when(@AsPredicate Predicate predicate) {
        return this.onWhen(predicate);
    }

    public InterceptSendToEndpointDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new OnWhenDefinition(predicate));
        return this;
    }

    public InterceptSendToEndpointDefinition skipSendToOriginalEndpoint() {
        this.setSkipSendToOriginalEndpoint(Boolean.toString(true));
        return this;
    }

    public InterceptSendToEndpointDefinition afterUri(String uri) {
        this.setAfterUri(uri);
        return this;
    }

    @Deprecated
    public void afterPropertiesSet() {
    }

    public String getSkipSendToOriginalEndpoint() {
        return this.skipSendToOriginalEndpoint;
    }

    public void setSkipSendToOriginalEndpoint(String skipSendToOriginalEndpoint) {
        this.skipSendToOriginalEndpoint = skipSendToOriginalEndpoint;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getAfterUri() {
        return this.afterUri;
    }

    public void setAfterUri(String afterProcessor) {
        this.afterUri = afterProcessor;
    }
}

