/*
 * main.c
 *
 * AUTHORS: Robert Fahy <rfahy@ymail.com>
 * CREDITS: n/a
 * VERSION: 1.00
 *
 */

/*
 * TASK:
 * - contains `main()' function
 *
 */

/*
 * TODO:
 * - n/a
 *
 */

// standard include files
#include <stdlib.h>

// custom include files
#include "baseop.h"
#include "coreop.h"
#include "defaults.h"

// ### MAIN FUNCTION ###
int main(int argc, char **argv)
// ### MAIN FUNCTION ###
{
	if (argc > 4)
	// more than four arguments passed...
	// (program path + input filename + output filename + keyfile filename)
	{
		print_usage(argv[0], "Too many arguments.");
		return EXIT_FAILURE;
	}

	if (argc < 1)
	// NOTE: this shouldn't normally be possible except with a
	//  specially crafted exec() call from another program
	{
		print_usage(DEFAULT_PROGRAM_FILENAME, "Nice try.");
		return EXIT_FAILURE;
	}

	if (argc == 1)
	// only got program path, but we need at least one filename
	{
		print_usage(argv[0], "The program needs at least one argument.");
		return EXIT_FAILURE;
	}

	signals_setup(); // so that we have the chance to clean up on catching the "SIGTERM" signal (and maybe others)

	switch (argc)
	// depending on the number of arguments (note that program path argument is also counted), we choose a course of action aka "case"
	{
		case 2: return compute_case1(argv[1]); // case 1: input file overwritten, key from standard input
		case 3: return compute_case2(argv[1], argv[2]); // case 2: input file, output file, key from standard input
		case 4: return compute_case3(argv[1], argv[2], argv[3]); // case 3: input file, output file, key file
		default:
			print_usage(argv[0], "Unknown. Email <rfahy@ymail.com> and include detail, please.");
			return EXIT_FAILURE;
	}
} // ### MAIN FUNCTION ###
