/*
 *  Linux Frame Buffer Device Configuration
 *
 *   Copyright 1995-1998 by Geert Uytterhoeven
 *			(Geert.Uytterhoeven@cs.kuleuven.ac.be)
 *
 *  --------------------------------------------------------------------------
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of the Linux
 *  distribution for more details.
 */
 /*
  * 
 * <LIC_AMD_STD>
 * Copyright (c) previous_year-2004 Advanced Micro Devices, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * The full GNU General Public License is included in this distribution in the
 * file called COPYING
 * </LIC_AMD_STD>
  * 
  * <CTL_AMD_STD>
  * </CTL_AMD_STD>
  * 
  * <DOC_AMD_STD>
  * </DOC_AMD_STD>
  * 
  */



#include <stdio.h>
#include <sys/types.h>

#ifdef __GLIBC__
#include <asm/types.h>
#endif

#define VERSION         "Linux Frame Buffer Device Configuration " \
			"Version 2.1 (23/06/1999)\n"  \
			"(C) Copyright 1995-1999 by Geert Uytterhoeven\n"

#define LOW		(0)
#define HIGH		(1)

#define FALSE		(0)
#define TRUE		(1)

#define PUT_TVO      0x4701
#define FB_DEBUG    0x4702
struct color {
    unsigned int length;
    unsigned int offset;
};

struct VideoMode {
    struct VideoMode *next;
    const char *name;
    /* geometry */
    __u32 xres;
    __u32 yres;
    __u32 vxres;
    __u32 vyres;
    __u32 depth;
    __u32 nonstd;
    /* acceleration */
    __u32 accel_flags;
    /* timings */
    __u32 pixclock;
    __u32 left;
    __u32 right;
    __u32 upper;
    __u32 lower;
    __u32 hslen;
    __u32 vslen;
    /* flags */
    unsigned hsync : 1;
    unsigned vsync : 1;
    unsigned csync : 1;
    unsigned gsync : 1;
    unsigned extsync : 1;
    unsigned bcast : 1;
    unsigned laced : 1;
    unsigned dblscan : 1;
    unsigned grayscale : 1;
    /* scanrates */
    double drate;
    double hrate;
    double vrate;
    /* RGB entries */
    struct color red, green, blue, transp;
	__u32 reserved[6];
};

extern FILE *yyin;
extern int line;
extern const char *Opt_modedb;

extern int yyparse(void);
extern void Die(const char *fmt, ...) __attribute__ ((noreturn));
extern void AddVideoMode(const struct VideoMode *vmode);
extern void makeRGBA(struct VideoMode *vmode, const char* opt);
